<?php

namespace App\Http\Controllers\Api\V11;

use App\Http\Controllers\Controller;
use App\Http\Requests\BusinessSetting\StoreBusinessSettingRequest;
use App\Models\Discount;
use App\Models\DiscountHour;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class BusinessSettingController extends Controller
{
    public function store(StoreBusinessSettingRequest $request){

        $company = auth()->user()->company;

        $end_date = null;
        if ($request->pause_discount) {
            $end_date = Carbon::now();
        }

        $gift_credit = 200;

        \DB::beginTransaction();
        try{
            $discount = Discount::create([
                'company_id' => $company->id,
                'name' => $request->name ?? "",
                'starts_at' => $request->starts_at ?: Carbon::now(),
                'ends_at' => $end_date,
                'terms' => $request->discount,
                'pt_percentage' => $request->prize_hour_discount,
                'amount' => $gift_credit,
                "pt_paying_amount" => $request->pay_amount
            ]);
    
            if($request->prize_hours && count($request->prize_hours) > 0){
                DiscountHour::where('discount_id', $discount->id)->delete();
                foreach ($request->prize_hours as $phour) {
                    if($phour['day'] && $phour['starts_at'] && $phour['ends_at']){
                        DiscountHour::create([
                            "discount_id" => $discount->id,
                            "day" => $phour['day'],
                            "starts_at" => $phour['starts_at'],
                            "ends_at" => $phour['ends_at']
                        ]);
                    }
                }
            }

            \DB::commit();
            return response()->json([
                "status" => "success",
                "message" => "Created Successfully",
                // "data" => null
            ], Response::HTTP_OK);
        }catch(\Exception $e){
            \DB::rollback();
            throw $e;
        }
        

    }
}
