<?php

namespace App\Http\Controllers\Api\V11;

use App\Http\Controllers\Controller;
use App\Http\Resources\CategoryResource;
use App\Models\Category;
use Illuminate\Http\Request;

class CategoryController extends Controller
{
    public function categoryList($company_id)
    {
        $perPage = request('per_page', 10);

        $categories = Category::has('products')->where('company_id', $company_id);
        $category_id = request('category_id');
        $menu_type_id = request('menu_id');

        if($menu_type_id){
            $categories->where("menu_id", $menu_type_id);
        }

        if($category_id){
            $categories->where('category_id', $category_id);
        }else{
            $categories->where('category_id', null);
        }

        $categories = $categories->paginate($perPage);
        return CategoryResource::collection($categories);
    }

}
