<?php

namespace App\Http\Controllers\Api\V11;

use App\Http\Controllers\Controller;
use App\Http\Resources\CustomerDiscountResource;
use App\Http\Resources\GlobalDiscountResource;
use App\Models\CustomerStripeInfo;
use App\Models\Discount;
use App\Models\GlobalDiscount;
use App\Models\Order;
use App\Models\Transaction;
use App\Models\UserGlobalDiscount;
use App\Repositories\DiscountClaimRepository;
use Illuminate\Http\Request;
use Auth;
use Cartalyst\Stripe\Stripe;

class DiscountController extends Controller
{

    public function globalDiscounts(){

        // $user = Auth::user();
        // $claim_repo = new DiscountClaimRepository();
        // $remainingGlobalCredit = $claim_repo->remainginGlobalCredit($user?->id) ?: 0;
        // if($remainingGlobalCredit > 0){
        //     $global_discounts = [];
        // }else{
        // }
        $global_discounts = GlobalDiscount::orderBy('credit_amount', 'asc')->get();
        return GlobalDiscountResource::collection($global_discounts);
    }

    public function companyDiscount($company_id){

        $discount = Discount::where('company_id', $company_id)->first();
        // return new CompanyResource($company);
        return new CustomerDiscountResource($discount);
    }


    public function buyGlobalDiscount(Request $request){

        $discount = GlobalDiscount::findOrFail($request->discount_id);

        $user = Auth::user();
        $claim_repo = new DiscountClaimRepository();
        $full_discount = 0;
        if($request->order_id && $request->company_id){
            $order = Order::find($request->order_id);
            $full_discount = $claim_repo->discountAmount($user , $order->subtotal, $request->company_id);
            $remainingGlobalCredit = $claim_repo->remainginGlobalCredit($user->id);

            if($remainingGlobalCredit > $full_discount){
                return response()->json([
                    "status" => "failed",
                    "message" => "Failed to bought"
                ], 500);
            }
        }
        
        $customer_stripe_info = CustomerStripeInfo::where('customer_id', $user->id)->first();

        $customer_stripe_customer_id = $customer_stripe_info->stripe_cus_id;
        $customer_stripe_payment_id = $customer_stripe_info->stripe_pm_id;
        
        $stripe = new Stripe(config('stripe.secret'));


        $current_hour = date("H");
        $show_discount_type = "";
        if($current_hour == 0){
            $show_discount_type = "regular";
            $cycle = 2; // putting even value for regular
        }else{
            // 2/2=1
            // 4/2 =2
            // 6/2 = 3
            // 8/2 =4
            // 10/2=5
            // 12/2=6
            // 14/2=7
            $cycle = $current_hour / 2;
            $show_discount_type = $cycle % 2 == 0 ? "regular" : "deal";
        }

        $price = $show_discount_type == "deal" ? $discount->deal_price : $discount->regular_price;

        $paymentIntent = $stripe->paymentIntents()->create([
            'amount' => $price,
            'currency' => 'usd',  
            'customer' => $customer_stripe_customer_id,
            'payment_method' => $customer_stripe_payment_id,
            // 'off_session' => true,
            'confirm' => true,
        ]);

        if (!empty($paymentIntent) && $paymentIntent["status"] == "succeeded") {
    
            $transaction = Transaction::create([
                'user_id' => $user->id,
                'charge_id' => $paymentIntent["charges"]["data"][0]["id"],
                'type' => Transaction::BUY_DISCOUNT,
                'company_id' => $discount->company_id ?? null,
                'amount' => $price,
                'payment_intent_id' => $paymentIntent["id"]
            ]);

            
            $user_discount = new UserGlobalDiscount();
            $user_discount->user_id = $user->id;
            $user_discount->global_discount_id = $discount->id;
            $user_discount->credit_amount = $discount->credit_amount;
            $user_discount->save();

            if($request->order_id){
                $order = Order::find($request->order_id);
                $full_discount = $claim_repo->discountAmount($user , $order->subtotal, $request->company_id);
                $order->discount = $full_discount;
                $order->save();
            }
           
            return response()->json([
                "status" => "success",
                "message" => "Successfully bought"
            ], 200);
        }

        return response()->json([
            "status" => "failed",
            "message" => "Failed to bought"
        ], 500);
    }

    public function buyDiscount(Request $request){

        $discount = Discount::findOrFail($request->discount_id);

        $user = Auth::user();
        $customer_stripe_info = CustomerStripeInfo::where('customer_id', $user->id)->first();

        $customer_stripe_customer_id = $customer_stripe_info->stripe_cus_id;
        $customer_stripe_payment_id = $customer_stripe_info->stripe_pm_id;
        $chargeResult = $this->chargePayment($discount, $customer_stripe_customer_id , $customer_stripe_payment_id);

        if($chargeResult == true){
            return response()->json([
                "status" => "success",
                "message" => "Successfully bought"
            ], 200);
        }else{
            return response()->json([
                "status" => "failed",
                "message" => "Failed to bought"
            ], 500);
        }
    }

    public function chargePayment($discount, $customer_stripe_customer_id , $customer_stripe_payment_method_id)
    {

        $claim_repo = new DiscountClaimRepository();
        $user = Auth::user();
        if (!$claim_repo->canClaim($user,$discount->company_id)) {
            return false;
        }
     
        $stripe = new Stripe(config('stripe.secret'));

        $paymentIntent = $stripe->paymentIntents()->create([
            'amount' => $discount->pt_paying_amount,
            'currency' => 'usd',  
            'customer' => $customer_stripe_customer_id,
            'payment_method' => $customer_stripe_payment_method_id,
            // 'off_session' => true,
            'confirm' => true,
        ]);

        if (!empty($paymentIntent) && $paymentIntent["status"] == "succeeded") {
    
            $transaction = Transaction::create([
                'user_id' => $user->id,
                'charge_id' => $paymentIntent["charges"]["data"][0]["id"],
                'type' => Transaction::BUY_DISCOUNT,
                'company_id' => $discount->company_id,
                'amount' => $discount->pt_paying_amount,
                'payment_intent_id' => $paymentIntent["id"]
            ]);

            
            $d = $claim_repo->createClaim($user,$discount->company_id);
        
            return true;
        }

        return false;
    }
}
