<?php

namespace App\Http\Controllers\Api\V11;

use App\Http\Controllers\Controller;
use App\Http\Requests\Company\StoreCompanyRequest;
use App\Http\Requests\Company\UpdateCompanyRequest;
use App\Models\Company;
use App\Models\CompanyType;
use App\Models\User;
use Illuminate\Http\Request;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Hash as FacadesHash;
use Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class MerchantController extends Controller
{
    public function store(StoreCompanyRequest $request){

        $timeZoneId = $request->timezone;

        // if js failed to get timezone then use google
        if(!$timeZoneId){
            try{
                $apiKey = config('services.google_maps.api_key');
                $url = "https://maps.googleapis.com/maps/api/timezone/json?location={$request->business_latitude},{$request->business_longitude}&timestamp=0&key=$apiKey";

                $client = new Client();
                $response = $client->get($url);
            }catch(\Exception $e){
                return response()->json([
                    "errors" => [
                        "business_address" => [$e->getMessage()]
                    ]
                ], 422);
            }


            $data = json_decode($response->getBody(), true);
            $timeZoneId = $data['timeZoneId'];
        }
        // =====================

        $phone_number = $request->dial_code.$request->phone_number;
        $phone_number = str_replace('-', '', $phone_number);

        $chhphone = User::where('phone_number', $phone_number)->first();

        if($chhphone){
            return response()->json([
                "errors" => [
                    "phone_number" => ["Phone number already exists"]
                ]
            ],422);
        }

        \DB::beginTransaction();
        try{
            $user = User::create([
                'name' => $request->contact_person_name,
                'email' => $request->email,
                'type' => 1,
                'password' => FacadesHash::make($request->password),
                'phone_number' => $phone_number
            ]);



            $company_type = CompanyType::find($request->company_type);
            $cover_photo = asset("/storage/".$company_type->cover_photo);
            if($request->hasFile("cover_photo")){
                $cover_photo = $request->cover_photo->store('/', 'public');
                $cover_photo = asset("/storage/".$cover_photo);
            }

            $banner_image = asset("/storage/".$company_type->banner_image);
            if($request->hasFile("banner_image")){
                $banner_image = $request->banner_image->store('/', 'public');
                $banner_image = asset("/storage/".$banner_image);
            }

            $company = Company::create([
                'owner_id' => $user->id,
                'type_id' => $request->company_type,
                'name' => $request->company_name,
                'address_line_1'     => $request->business_address,
                'business_latitude'  => $request->business_latitude,
                'business_longitude' => $request->business_longitude,
                'business_timezone'  => $timeZoneId,
                "cover_photo" => $cover_photo,
                "banner_photo" => $banner_image,
                "slug" => Str::slug($request->company_name)
            ]);

            // $credentials = ['email' => $request->email, 'password' => $request->password];

            // if (Auth::attempt($credentials)) {
            //     return response()->json([
            //         'status'    => 'success',
            //         'msg'       => 'Registered successfully',
            //         'url'       => route('businessSetting')
            //     ],200);
            // }
            Auth::login($user);

            \DB::commit();
            return response()->json([
                'status'    => 'success',
                'msg'       => 'Registered successfully',
                "data" => [
                    "id" => $company->id
                ]
                // 'url'       => route('businessSetting')
            ],200);

        }catch(\Exception $e){
            \DB::rollback();
            throw $e;
        }

    }

    public function update($company_id, UpdateCompanyRequest $request){

        $company = Company::findOrFail($company_id);

        $phone_number = $request->dial_code.$request->phone_number;
        $phone_number = str_replace('-', '', $phone_number);

        $user = User::where('phone_number', $phone_number)->first();

            // if($chhphone){
            //     return response()->json([
            //         "errors" => [
            //             "phone_number" => ["Phone number already exists"]
            //         ]
            //     ],422);
            // }

            \DB::beginTransaction();
            try{
                if(!$user){
                    $user = User::create([
                        'name' => $request->contact_person_name,
                        'email' => $request->email,
                        'type' => 1,
                        'password' => FacadesHash::make($request->password),
                        'phone_number' => $phone_number
                    ]);
                }

                $company_type = CompanyType::find($request->company_type);
                $cover_photo = asset("/storage/".$company_type->cover_photo);
                if($request->hasFile("cover_photo")){
                    $cover_photo = $request->cover_photo->store('/', 'public');
                    $cover_photo = asset("/storage/".$cover_photo);
                }

                $banner_image = asset("/storage/".$company_type->banner_image);
                if($request->hasFile("banner_image")){
                    $banner_image = $request->banner_image->store('/', 'public');
                    $banner_image = asset("/storage/".$banner_image);
                }

                $company->update([
                    'owner_id' => $user->id,
                    'type_id' => $request->company_type,
                    'name' => $request->company_name,
                    'address_line_1'     => $request->business_address,
                    // 'business_latitude'  => $request->business_latitude,
                    // 'business_longitude' => $request->business_longitude,
                    "cover_photo" => $cover_photo,
                    "banner_photo" => $banner_image
                ]);

                // $credentials = ['email' => $request->email, 'password' => $request->password];

                // if (Auth::attempt($credentials)) {
                //     return response()->json([
                //         'status'    => 'success',
                //         'msg'       => 'Registered successfully',
                //         'url'       => route('businessSetting')
                //     ],200);
                // }
                Auth::login($user);

                \DB::commit();
                return response()->json([
                    'status'    => 'success',
                    'msg'       => 'Registered successfully',
                    "data" => [
                        "id" => $company->id
                    ]
                    // 'url'       => route('businessSetting')
                ],200);

            }catch(\Exception $e){
                \DB::rollback();
                throw $e;
            }

    }

    public function getOrCreateGoogleCompany(Request $request){

        $photoUrl = $request->photoUrl;
        $name = $request->name;
        $rating = $request->rating;
        $user_ratings_total = $request->user_ratings_total;
        $delivery = $request->delivery;
        $dine_in = $request->dine_in;
        $vicinity = $request->vicinity;
        $phone_number = $request->phone_number;
        $opening_hours = $request->opening_hours;
        $latitude = $request->latitude;
        $longitude = $request->longitude;

        // $phone_number = $request->dial_code.$request->phone_number;
        $phone_number = str_replace('-', '', $phone_number);
        $phone_number = str_replace('+', '', $phone_number);

        $company = Company::where('name', $name)->first();
        if($company){
            return response()->json([
                'status'    => 'success',
                'msg'       => 'Registered successfully',
                "data" => [
                    "id" => $company->id
                ]
                // 'url'       => route('businessSetting')
            ],200);
        }


        try{
            $apiKey = config('services.google_maps.api_key');
            // $url = "https://maps.googleapis.com/maps/api/timezone/json?location={$latitude},{$longitude}&timestamp=0&key=$apiKey";

            $url = "https://api.geoapify.com/v1/geocode/reverse?lat={$latitude}&lon={$longitude}&apiKey=b31cfe59009842f9a0bab8cb4c4c4bdd";


            $client = new Client();
            $response = $client->get($url);

        }catch(\Exception $e){
            return response()->json([
                "errors" => [
                    "business_address" => [$e->getMessage()]
                ]
            ], 422);
        }


        $data = json_decode($response->getBody(), true);
        $timezone = $data['features'][0]['properties']['timezone']['name'];

        if ($timezone) {

            $chhphone = User::where('phone_number', $phone_number)->first();

            // if($chhphone){
            //     return response()->json([
            //         "errors" => [
            //             "phone_number" => ["Phone number already exists"]
            //         ]
            //     ],422);
            // }

            \DB::beginTransaction();
            try{
                $user = null;
                if($phone_number){
                    $user = User::create([
                        'name' => $request->contact_person_name,
                        'email' => $request->email,
                        'type' => 1,
                        'password' => FacadesHash::make($request->password),
                        'phone_number' => $phone_number
                    ]);
                }

                // $timeZoneId = $data['timeZoneId'];

                // $company_type = CompanyType::find($request->company_type);
                // $cover_photo = asset("/storage/".$company_type->cover_photo);
                // if($request->hasFile("cover_photo")){
                //     $cover_photo = $request->cover_photo->store('/', 'public');
                //     $cover_photo = asset("/storage/".$cover_photo);
                // }

                // $banner_image = asset("/storage/".$company_type->banner_image);
                // if($request->hasFile("banner_image")){
                //     $banner_image = $request->banner_image->store('/', 'public');
                //     $banner_image = asset("/storage/".$banner_image);
                // }
                $cover_photo = $photoUrl;
                $banner_image = $photoUrl;

                $company = Company::create([
                    'owner_id' => $user?->id,
                    'type_id' => $request->company_type,
                    'name' => $request->name,
                    'address_line_1'     => $vicinity,
                    'business_latitude'  => $request->longitude,
                    'business_longitude' => $request->latitude,
                    'business_timezone'  => $timezone,
                    // "cover_photo" => $cover_photo,
                    // "banner_photo" => $banner_image,
                    "company_type" => "temp",
                    "status" => Company::STATUS_TEMP,
                    "slug" => Str::slug($request->name)
                ]);

                try{
                    $business_hours = [];
                    foreach ($request->opening_hours as $opening_hour) {
                        $day = $opening_hour['open']['day'];
                        $open = $opening_hour['open']['time'];
                        $close = $opening_hour['close']['time'];

                        $open = chunk_split($open,2,":")."00";
                        $close = chunk_split($close,2,":")."00";

                        if($open && $close && $day){
                            array_push($business_hours, [
                                "company_id" => $company->id,
                                "menu_type_id" => 1,
                                "day" => $day,
                                "from" => $open,
                                "to" => $close
                            ]);
                        }

                    }
                    $company->businesshours()->insert($business_hours);
                }catch(\Exception $e){

                }

                // $credentials = ['email' => $request->email, 'password' => $request->password];

                // if (Auth::attempt($credentials)) {
                //     return response()->json([
                //         'status'    => 'success',
                //         'msg'       => 'Registered successfully',
                //         'url'       => route('businessSetting')
                //     ],200);
                // }
                // Auth::login($user);

                \DB::commit();
                return response()->json([
                    'status'    => 'success',
                    'msg'       => 'Registered successfully',
                    "data" => [
                        "id" => $company->id
                    ]
                    // 'url'       => route('businessSetting')
                ],200);

            }catch(\Exception $e){
                \DB::rollback();
                throw $e;
            }

        } else {
            return response()->json([
                'status'    => 'fail',
                'msg'       => "Unable to retrieve time zone.",
            ],200);
        }

    }
}
