<?php

namespace App\Http\Controllers\Api\V11;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Resources\CompanyResource;
use App\Http\Resources\OrderResource;
use App\Models\CustomerStripeInfo;
use App\Models\Cart;
use App\Models\CartProductOptions;
use Illuminate\Http\Request;
use App\Models\Tax;
use App\Models\Transaction;
use App\Models\User;
use App\Models\Order;
use App\Models\Table;
use App\Models\Company;
use App\Models\CustomerReservations;
use App\Models\Egift;
use App\Models\Employee;
use App\Models\OrderProducts;
use App\Models\UserOrder;
use App\Repositories\DiscountClaimRepository;
use Carbon\Carbon;
use Hamcrest\Type\IsNumeric;
use App\Models\Product;
use App\Models\Tip;
use App\Models\UsedEgift;
use App\Models\UsedGlobalDiscount;
use App\Notifications\PhoneVerificationCode;
use Auth;
use Cartalyst\Stripe\Stripe;
use Symfony\Component\HttpFoundation\Response;
use DB;

class OrderController extends Controller
{
    public function customerOrders(){
        $orders = Order::where('user_id', auth()->user()->id)->orderBy('created_at', 'desc')->paginate(20);
        return OrderResource::collection($orders);
    }

    public function companyOrders($company_id){
        $orders = Order::where('company_id', $company_id)
                    ->where("status", Order::STATUS_NEW)->orderBy('created_at', 'desc')->paginate(20);
        return OrderResource::collection($orders);
    }

    //Danial Code
    public function saveCustomerOrder(Request $request){

        \DB::beginTransaction();
        try{
            $temp_user_id = $request->temp_user_id;
            $company_id = $request->company_id;

            if($request->user_id){
                $user = User::find($request->user_id);
            }else{
                $user = Auth::user();
            }

            $employee           =   Employee::where('company_id',$company_id)->first();
            $table              =   null;
            if($request->has('table_id') && $request->table_id > 0){
                $table          =   Table::with('area')->where('id',$request->table_id)->first();
            }

            $table_area_type = 'table';

            $order      =   $user->orders()->create([
                'status'            =>  Order::STATUS_NEW,
                'type'              =>  $request->type ? $request->type : 0,
                'company_id'        =>  $company_id,
                'employee_id'       =>  $employee ? $employee->id : null,
                'user_id'           =>  $user->id,
                'table_id'          =>  $request->table_id ? $request->table_id:null,
                // 'table_area_type'   =>  $table_area_type,
                'subtotal'          =>  0,
            ]);

            //         $user_order = $order->userOrders()->create([
            //             'order_id' => $order->id,
            //             'status' => 0,
            //             'user_id' => $user->id,
            //             'company_id' => $order->company_id,
            //             'products' => json_encode($request->products),
            //             'subtotal' => 0,
            // //                'tax' => $request->tax ? $request->tax : 0,
            //             'tips' => $request->tips ? $request->tips : 0,
            //             'discount' => $request->discount ? $request->discount : 0,
            // //                'total'    =>  ($order->subtotal - $request->discount + ((($order->subtotal - $request->discount) * $request->tax) / 100) + $request->tips)
            //         ]);

            $subtotal = 0;
            $o_products = [];
            $cartItems = Cart::where('temp_user_id', $temp_user_id)->get();
            foreach ($cartItems as $cartItem) {
                $product = $cartItem->product;
                $order_product          = new OrderProducts();
                $order_product->order_id = $order->id;
                $order_product->product_id = $product->id;
                // $order_product->user_order_id = $user_order->id;
                $order_product->product_qty = $cartItem->quantity;
                $order_product->product_unit_price = $product->price;
                $order_product->product_type = 'size';
                $order_product->product_total_price = $cartItem->quantity * $product->price;
                $order_product->product_subtotal = $order_product->product_total_price;
                $order_product->product_options = $cartItem->option_data;
                $order_product->save();

                $orderOptions = json_decode($cartItem->option_data);
                $optionTotal = 0;
                foreach ($orderOptions as $copt){
                    foreach ($copt->options as $op){
                        $optionTotal += $op->price ?? 0;
                    }
                }

                // $orderProduct = $order->orderProducts()->create([
                //     'order_id' => $order->id,
                //     'user_id' => $user->id,
                //     'product_id' => $product->id,
                //     // 'product_price_id' => $request->input('product_price_id'),
                //     // 'size_id' => $request->input('size_id'),
                //     // 'product' => $request->input('product'),
                //     // 'amount' => $request->input('amount'),
                //     'price' => $product['prices']['price'],
                //     'product_options' => $cartItem->option_data
                // ]);

                $subtotal += $order_product->product_total_price + $optionTotal;

                array_push($o_products, [
                    "product_name" => $product->name,
                    "quantity" => $cartItem->quantity,
                    "options" => json_decode($cartItem->option_data),
                ]);
            }


            // $subtotal               =   OrderProducts::where('user_order_id', $user_order->id)->sum('product_subtotal');

            // $claim_repo = new DiscountClaimRepository();
            // $discountObj = $claim_repo->getActiveDiscount($order->company_id);
            // $discount = $claim_repo->discountAmount($user , $subtotal, $order->company_id);

            // $remaining_balance = $claim_repo->remainginGlobalCredit($user->id);

            // if($remaining_balance > 0){
            //     $discount = $discount > $remaining_balance ? $remaining_balance : $discount;
            // }else{
            //     $discount = 0;
            // }

            $tax                    =   Tax::where('company_id', $order->company_id)->first();
            $tax_amount             =   $tax ? ($subtotal * $tax->tax) / 100 : 0;
            // UserOrder::where('id', $user_order->id)->update([
            //     'products'  =>  [],
            //     'subtotal'  =>  $subtotal,
            //     'discount'  =>  $discount,
            //     'tax'       =>  $tax_amount,
            //     'total'     =>  ($subtotal - $discount + $tax_amount + $user_order->tips)
            // ]);


            Cart::where('temp_user_id', $temp_user_id)->delete();


            $total = $subtotal + $tax_amount;

            // $use_egift = 0;
            // $egift_amount = Egift::where('user_id', $user->id)->sum("gift_amount");
            // $used_egift = UsedEgift::where('user_id', $user->id)->sum("used_amount");
            // $egift_balance = $egift_amount - $used_egift;

            // if($egift_balance > 0){
            //     $use_egift = $egift_balance > $total ? $total : $egift_balance;
            // }

            $order->update([
                // 'products'  =>  $o_products,
                'subtotal' => $subtotal,
                "tax" => $tax_amount,
                "tips" => 0,
                "discount" => 0,
                // "used_egift" => $use_egift,
                "total" => $total
            ]);

            $reservation    =  CustomerReservations::where('customer_id', Auth::user()->id)
                ->where("status", '<=',CustomerReservations::STATUS_ASSIGNED)
                ->where('order_id', '=', null)
                ->first();

            if($reservation){
                $reservation->order_id = $order->id;
                $reservation->save();
            }

            \DB::commit();
            return response()->json([
                'success' => true,
                'message'        => 'Order Saved successfully',
                'data' => [
                    "order_id" => $order->id
                ]
            ], 200);
        }catch(\Exception $e){
            \DB::rollback();
            throw $e;
        }

    }


    public function employeePlaceOrder(Request $request){

        $temp_user_id = $request->temp_user_id;
        if(!$temp_user_id) $temp_user_id = session()->get("temp_user_id");

        $user_id = $request->user_id;

        $request->validate([
//                'status'      => 'required|numeric',
//                'type'        => 'required',
            'company_id'    => 'required|numeric',
//                'area_id'      => 'required|numeric',
            'user_id'       => 'required|numeric',
//                'employee_id'   => 'required|numeric',
//                'table_id'      => 'required|numeric',
//                'number'        => 'required',
            // 'products'      => 'required',
        ]);

            $user               =   User::find($user_id);

            $employee           =   Employee::where('company_id',$request->company_id)->first();
            $table              =   null;
            if($request->has('table_id') && $request->table_id > 0){
                $table          =   Table::with('area')->where('id',$request->table_id)->first();
            }


            $table_area_type = 'table';

            // if($request->type && $request->type == 1){

            //     $table_area_type =   'pickup';
            //     $IsPending       =     Order::selectRaw("orders.*,user_order.id as user_order_id")->join("user_order",function ($join) use($request){
            //                                         $join->on("user_order.order_id",'=',"orders.id")
            //                                             ->where('user_order.user_id', $request->user_id);
            //                                     })
            //                                     ->where('orders.company_id',$request->company_id)
            //                                     ->where('orders.table_area_type', 'pickup')
            //                                     ->whereNUll('is_pickup_confirmed')
            //                                     ->first();
            //     if($IsPending){
            //         if($IsPending->status == 1){
            //             return response()->json([
            //                 'message' => 'Please ask company admin to confirm pickup for this order first for previous order on this table.',
            //                 'pending-data'=>$IsPending
            //             ], 400);
            //         }
            //         if(is_null($IsPending->table_id)){
            //             return response()->json([
            //                 'message' => 'User already have active Take out pickup order.',
            //                 'pending-data'=>$IsPending
            //             ], 400);
            //         }
            //         return response()->json([
            //             'message' => 'User already have active pickup order.',
            //             'pending-data'=>$IsPending
            //         ], 400);
            //     }

            // }
            // elseif($table && $table->area && $table->area->type == 'pickup'){

            //     $table_area_type=   'pickup';
            //     $IsPending       =     Order::selectRaw("orders.*,user_order.id as user_order_id")->join("user_order",function ($join) use($request){
            //         $join->on("user_order.order_id",'=',"orders.id")
            //             ->where('user_order.user_id', $request->user_id);
            //     })
            //         ->where('orders.company_id',$request->company_id)
            //                                 ->where('orders.table_area_type', 'pickup')
            //                                 ->whereNUll('is_pickup_confirmed')
            //                                 ->first();
            //     if($IsPending){
            //         if($IsPending->status == 1){
            //             return response()->json([
            //                 'message' => 'Please ask company admin to confirm pickup for this order first for previous order on this table.',
            //                 'pending-data'=>$IsPending
            //             ], 400);
            //         }
            //         if(is_null($IsPending->table_id)){
            //             return response()->json([
            //                 'message' => 'User already have active Take out pickup order.',
            //                 'pending-data'=>$IsPending
            //             ], 400);
            //         }
            //         return response()->json([
            //             'message' => 'User already have active pickup order.',
            //             'pending-data'=>$IsPending
            //         ], 400);
            //     }

            //     //check Table
            //     $IsPending      =   Order::whereNotNull('table_id')
            //                                 ->where('orders.company_id',$request->company_id)
            //                                 ->where('table_id',$table->id)
            //                                 ->where('orders.table_area_type', 'pickup')
            //                                 ->whereNUll('is_pickup_confirmed')
            //                                 ->first();
            //     if($IsPending){
            //         return response()->json([
            //             'message' => 'Table is already taken.',
            //             'pending-data'=>$IsPending
            //         ], 400);
            //     }
            // }
            // else{
            //     $table_area_type    =   'table';
            //     $IsPending          =   Order::selectRaw("orders.*,user_order.id as user_order_id")->join("user_order",function ($join) use($request){
            //                                         $join->on("user_order.order_id",'=',"orders.id")
            //                                         ->where('user_order.user_id', $request->user_id);
            //                                 })
            //                                 ->where('orders.company_id',$request->company_id)
            //                                 ->where('orders.table_area_type', 'table')
            //                                 ->whereIn('user_order.status',[Order::STATUS_NEW,Order::STATUS_ASSIGNED])
            //                                 ->first();
            //     if($IsPending){
            //         return response()->json([
            //             'message' => 'User already have pending order.',
            //             'pending_order' => $IsPending,
            //         ], 400);
            //     }

            //     if($table){
            //         $IsPending    =   Order::selectRaw("orders.*,user_order.id as user_order_id")->join("user_order",function ($join){
            //                                 $join->on("user_order.order_id",'=',"orders.id");
            //                             })
            //                             ->where('orders.company_id',$request->company_id)
            //                             ->where('table_id',$table->id)
            //                             ->where('orders.table_area_type', 'table')
            //                             ->whereIn('user_order.status',[Order::STATUS_NEW,Order::STATUS_ASSIGNED])
            //                             ->first();
            //         if($IsPending){
            //             return response()->json([
            //                 'message'       => 'Table is already taken.',
            //                 'pending_order' => $IsPending,
            //             ], 400);
            //         }

            //     }
            // }

            $order      =   $user->orders()->create([
                'status'            =>  Order::STATUS_NEW,
                'type'              =>  $request->type ? $request->type : 0,
                'company_id'        =>  $request->company_id,
                'employee_id'       =>  $employee ? $employee->id : null,
                'user_id'           =>  $user->id,
                'table_id'          =>  $request->table_id ? $request->table_id:null,
                'table_area_type'   =>  $table_area_type,
                'subtotal'          =>  0,
            ]);

            $user_order = $order->userOrders()->create([
                'order_id' => $order->id,
                'status' => 0,
                'user_id' => $request->user_id,
                'company_id' => $order->company_id,
                'products' => json_encode($request->products),
                'subtotal' => 0,
//                'tax' => $request->tax ? $request->tax : 0,
                'tips' => $request->tips ? $request->tips : 0,
                'discount' => $request->discount ? $request->discount : 0,
//                'total'    =>  ($order->subtotal - $request->discount + ((($order->subtotal - $request->discount) * $request->tax) / 100) + $request->tips)
            ]);


            $subtotal = 0;
            $cartItems = Cart::where('temp_user_id', $temp_user_id)->get();
            foreach ($cartItems as $cartItem) {
                $product = $cartItem->product;

                $order_product          = new OrderProducts();
                $order_product->product_id = $product->id;
                $order_product->user_order_id = $user_order->id;
                $order_product->product_qty = $cartItem->quantity;
                $order_product->product_unit_price = $product['prices']['price'];
                $order_product->product_type = 'size';
                $order_product->product_total_price = $cartItem->quantity * $product['prices']['price'];
                $order_product->product_subtotal = $order_product->product_total_price;
                $order_product->save();

                $subtotal += $order_product->product_total_price;
            }

            // $subtotal               =   OrderProducts::where('user_order_id', $user_order->id)->sum('product_subtotal');
            $claim_discount         =   $request->discount ? $request->discount : 0;
            $tax                    =   Tax::where('company_id', $order->company_id)->first();
            $tax_amount             =   $tax ? ((($subtotal - $claim_discount) * $tax->tax) / 100) :0;
            UserOrder::where('id', $user_order->id)->update([
                'products'  =>  [],
                'subtotal'  =>  $subtotal,
                'discount'  =>  $claim_discount,
                'tax'       =>  $tax_amount,
                'total'     =>  ($subtotal - $claim_discount + $tax_amount + $user_order->tips)
            ]);

            Cart::where('temp_user_id', $temp_user_id)->delete();

            Order::where('id', $user_order->order_id)->update([
                'products'  =>  [],
                'subtotal' => $subtotal
            ]);

            $reservation = CustomerReservations::find($request->reservation_id);
            $reservation->order_id = $order->id;
            $reservation->save();

            return response()->json([
                'success' => true,
                'message'        => 'Order Saved successfully',
                'data' => [
                    "order_id" => $order->id
                ]
            ], 200);

    }

    public function customerPlaceOrder(StoreCustomerOrderRequest $request,  User $user)
    {
        $order = $user->orders()->create([
            'status' => $request->validated('status'),
            'type' => $request->validated('type'),
            'company_id' => $request->validated('company_id'),
            'area_id' => $request->validated('area_id'),
            'table_id' => $request->validated('table_id'),
            'number' => $request->validated('number'),
            'products' => $request->validated('products'),
            'subtotal' => $request->validated('subtotal'),
        ]);

        $order->userOrders()->create([
            'status' => 0,
            'user_id' => $user->id,
            'company_id' => $order->company_id,
            'products' => $order->products,
            'subtotal' => $order->subtotal,
            'tax' => $request->tax ?? 0,
            'tips' => $request->tips ?? 0,
            'discount' => $request->discount ?? 0,
            //'total' => ($order->subtotal + (($order->subtotal * $request->tax) / 100) + $request->tips) - $request->discount
            'total' => ($order->subtotal - $request->discount + ((($order->subtotal - $request->discount) * $request->tax) / 100) + $request->tips)
        ]);


        $order->update([
            //     //'subtotal' => ($order->subtotal + (($order->subtotal * $request->tax) / 100) + $request->tips) - $request->discount
            'subtotal' => ($order->subtotal - $request->discount + ((($order->subtotal - $request->discount) * $request->tax) / 100) + $request->tips)
        ]);

        return response()->json([
            'order' => $order
        ], 200);

    }


    public function storeAsEmployee(Request $request, Employee $employee)
    {
        $request->validate([
            'status' => 'required|numeric',
            'type' => 'required|numeric',
            'company_id' => 'required|numeric',
            'area_id' => 'required',
            'user_id' => 'sometimes',
            'table_id' => 'required',
            'number' => 'sometimes',
            'products' => 'sometimes',
            'subtotal' => 'sometimes',
        ]);

        $order = $employee->orders()->create([
            'status' => $request->input('status'),
            'type' => $request->input('type'),
            'company_id' => $request->input('company_id'),
            'area_id' => $request->input('area_id'),
            'user_id' => $request->input('user_id'),
            'table_id' => $request->input('table_id'),
            'number' => $request->input('number'),
            'products' => $request->input('products'),
            'subtotal' => $request->input('subtotal'),
        ]);

        $order->userOrders()->create([
            'status' => 0,
            'user_id' => $order->user_id,
            'company_id' => $order->company_id,
            'products' => $order->products,
            'subtotal' => $order->subtotal,
            'tax' => $request->tax ?? 0,
            'tips' => $request->tips ?? 0,
            'discount' => $request->discount ?? 0,
            'total' => ($order->subtotal + (($order->subtotal * $request->tax) / 100) + $request->tips) - $request->discount
        ]);

        $order->update([
            'subtotal' => ($order->subtotal + (($order->subtotal * $request->tax) / 100) + $request->tips) - $request->discount
        ]);

        return response()->json([
            'order' => $order
        ], 200);
    }

    public function createTableOrder(Request $request, Employee $employee)
    {

        $user = $request->user('sanctum');

        $request->validate([
            'type' => 'required|in:0,1,2,3',
            'company_id' => 'required|integer|exists:companies,id',
            'user_id' => 'sometimes|exists:users,id',
            'table_id' => 'sometimes|exists:tables,id',
            'products' => 'sometimes',
            'subtotal' => 'required|numeric|min:1|max:1000000',
        ]);

        if(!$user->company?->id){
            return response()->json(['message' => 'You do not have a company associated with this user'], 400);
        }

        if(!$user || $user->company->id != $request->company_id){
            return response()->json(['message' => 'You do not have right to access this company'], 403);
        }

        if($request->company_id != $employee->company_id){
            return response()->json(['message' => 'Employee doesnt belong this company'], 403);
        }

        $order = $employee->orders()->create([
            'status' => Order::STATUS_NEW,
            'type' => $request->type,
            'company_id' => $request->company_id,
            'user_id' => $request->user_id,
            'table_id' => $request->table_id,
            'products' => $request->products,
            'subtotal' => $request->subtotal,
        ]);

        $order->splitEqual(1);
        $order->load('userOrders');

        return response()->json([
            'order' => $order
        ], 200);
    }


    public function orderDetails($order_id)
    {
        $order = Order::where("id" , $order_id)->first();
        return new OrderResource($order);
    }

    public function payNow(Request $request){


        $user = Auth::user();
        $order = Order::findOrFail($request->order_id);

        if($order->status == Order::STATUS_PAID){
            return response()->json([
                "success" => false,
                "message" => "Order is already paid"
            ], 500);
        }

        $tip = 0;
        if($request->tip_id){
            $tipObj = Tip::where('company_id', $order->company_id)->where('id', $request->tip_id)->first();
            $tip = ($order->subtotal * ($tipObj?->tip / 100));
        }


        $total = $order->total + $tip;
        $original_total = $order->total + $tip;

        $claim_repo = new DiscountClaimRepository();
        $discount = $claim_repo->discountAmount($user , $order->subtotal, $order->company_id);


        DB::beginTransaction();
        try{

            // Apply Global Gift Credit First
            $global_credit_amount = $claim_repo->remainginGlobalCredit($user->id);

            if($global_credit_amount > 0){
                if($global_credit_amount >= $discount){
                    $order->used_global_credit = $discount;
                    $claim_repo->createGlobalUsedDiscountEntry($user , $order->id , $discount, $order->company_id);
                    $total = $total - $discount;
                }else{
                    $order->used_global_credit = $global_credit_amount;
                    $claim_repo->createGlobalUsedDiscountEntry($user , $order->id , $global_credit_amount, $order->company_id);
                    $total = $total - $global_credit_amount; // remaining total after partial payment with global credit
                }
            }


            if($total > 0){

                $egift_amount = Egift::where('user_id', $user->id)->sum("gift_amount");
                $used_egift = UsedEgift::where('user_id', $user->id)->sum("used_amount");
                $egift_balance = $egift_amount - $used_egift;

                if($egift_balance > 0){

                    if($egift_balance >= $total){
                        $order->status = Order::STATUS_PAID;
                        $order->used_egift = $total;
                        $total = 0;
                    }else{
                        $order->used_egift = $egift_balance;
                        $total = $total - $egift_balance;
                    }

                    UsedEgift::create([
                        "company_id" => $order->company_id,
                        "order_id" => $order->id,
                        'user_id' => $user->id,
                        "used_amount" => $order->used_egift,
                    ]);
                }
            }


            if($total > 0){
                // Pay by Card
                $customer_stripe_info = CustomerStripeInfo::where('customer_id', $user->id)->first();
                $customer_stripe_customer_id = $customer_stripe_info->stripe_cus_id;
                $customer_stripe_payment_id = $customer_stripe_info->stripe_pm_id;

                $stripe = new Stripe(config('stripe.secret'));

                $paymentIntent = $stripe->paymentIntents()->create([
                    'amount' => $total,
                    'currency' => 'usd',
                    'customer' => $customer_stripe_customer_id,
                    'payment_method' => $customer_stripe_payment_id,
                    'off_session' => true,
                    'confirm' => true,
                ]);

                if (!empty($paymentIntent) && $paymentIntent["status"] == "succeeded") {


                    $transaction = Transaction::create([
                        'user_id' => Auth::user()->id,
                        'charge_id' => $paymentIntent["charges"]["data"][0]["id"],
                        'type' => Transaction::FOOD_ORDER,
                        'company_id' => $order->company_id,
                        'amount' => $total,
                        'order_id' => $order->id,
                        // 'user_order_id'=> !empty($order->userOrders[0]) ?  $order->userOrders[0]->id : null,
                        'payment_intent_id' => $paymentIntent["id"]
                    ]);


                    $reservation = CustomerReservations::where('order_id', $order->id)->first();
                    if($reservation){
                        $reservation->status = CustomerReservations::STATUS_COMPLETED;
                        $reservation->save();
                    }

                    $total = 0;
                }
            }


            if($total == 0){
                $order->status = Order::STATUS_PAID;
                $order->tips = $tip;
                $order->total = $order->total + $tip;
                $order->save();
            }

            DB::commit();
            return response()->json([
                "status" => "success",
                "message" => "Payment Successful"
            ], 200);
        }catch(\Exception $e){
            DB::rollback();
            throw $e;
        }

    }


    public function enterSubtotal(Request $request)
    {

        $employee_id = $request->employee_id;
        $employee = Employee::find($employee_id);
        $user = auth()->user();

        $request->validate([
            'type' => 'required|in:0,1,2,3',
            'company_id' => 'required|integer|exists:companies,id',
            'user_id' => 'sometimes|exists:users,id',
            'products' => 'sometimes',
            'subtotal' => 'required|numeric|min:1|max:1000000',
        ]);

        if(!$user->company?->id){
            return response()->json(['message' => 'You do not have a company associated with this user'], 400);
        }

        if(!$user || $user->company->id != $request->company_id){
            return response()->json(['message' => 'You do not have right to access this company'], 403);
        }

        if($request->company_id != $employee->company_id){
            return response()->json(['message' => 'Employee doesnt belong this company'], 403);
        }

        $order = $employee->orders()->create([
            'status' => Order::STATUS_NEW,
            'type' => $request->type,
            'company_id' => $request->company_id,
            'user_id' => $request->user_id,
            // 'products' => $request->products,
            'subtotal' => $request->subtotal,
            'total' => $request->subtotal
        ]);

        // $order->splitEqual(1);
        // $order->load('userOrders');
        foreach ($request['products'] as $product) {

            $order_product          = new OrderProducts();
            $order_product->order_id = $order->id;
            $order_product->product_id = null;
            $order_product->product_name = $product['name'];
            // $order_product->user_order_id = $user_order->id;
            $order_product->product_qty = 1;
            $order_product->product_unit_price = $request->subtotal;
            $order_product->product_type = 'size';
            $order_product->product_total_price = $request->subtotal;
            $order_product->product_subtotal = $request->subtotal;
            $order_product->product_options = "[]";
            $order_product->save();

        }

        if($request->reservation_id){
            $reservation = CustomerReservations::find($request->reservation_id);
            $reservation->order_id = $order->id;
            $reservation->save();
        }

        return response()->json([
            "success" => true,
            "message" => "Inserted Successfully",
            "data" => $order->id
        ], Response::HTTP_OK);
    }


    public function addProductToOrder(Request $request){

        \DB::beginTransaction();
        try{
            $order_id = $request->order_id;
            $product_id = $request->product_id;

            if(!$order_id){
                $order = new Order();
                $order->company_id = $request->company_id;
                $order->save();
            }else{
                $order = Order::findOrFail($order_id);
            }

            $product = Product::findOrFail($product_id);

            $optionData = [];
            $optionPrice = 0;

            $reqProduct = json_decode($request->product, true) ?: [];
            if(array_key_exists("custom_size", $reqProduct) && $reqProduct['custom_size'] && count($reqProduct['custom_size']) > 0){
                foreach ($reqProduct['custom_size'] as $csize) {
                    foreach ($csize['custom_group'] as $cgroup) {
                        $d = [];
                        $d['options'] = [];
                        foreach($cgroup['options'] as $options){
                            if($options['is_checked'] == true){
                                array_push($d['options'], [
                                    'option_id' => $options['id'],
                                    'option_name' => \App\Models\Option::find($options['id'])?->name,
                                    'price' => $options['price'],
                                ]);
                                $optionPrice += $options['price'];
                            }
                        }
                        if(count($d['options']) > 0){
                            $d['group_id'] = $cgroup['id'];
                            $d['group_name'] = \App\Models\OptionGroup::find($cgroup['id'])?->name;
                            $d['size_id'] = $csize['id'];
                            $d['size_name'] = \App\Models\Size::find($csize['id'])?->name;
                            array_push($optionData, $d);
                        }
                    }
                }
            }else if(array_key_exists("custom_group", $reqProduct)){
                foreach ($reqProduct['custom_group'] as $cgroup) {
                    $d = [];
                    $d['options'] = [];
                    foreach($cgroup['options'] as $options){
                        if($options['is_checked'] == true){
                            array_push($d['options'], [
                                'option_id' => $options['id'],
                                'option_name' => \App\Models\Option::find($options['id'])?->name,
                                'price' => $options['price'],
                            ]);
                            $optionPrice += $options['price'];
                        }
                    }
                    if(count($d['options']) > 0){
                        $d['group_id'] = $cgroup['id'];
                        $d['group_name'] = \App\Models\OptionGroup::find($cgroup['id'])?->name;
                        $d['size_id'] = null;
                        $d['size_name'] = null;
                        array_push($optionData, $d);
                    }
                }
            }

            $order_product = OrderProducts::where('order_id', $order->id)->where('product_id', $product_id)->first();

            if(!$order_product){
                $order_product          = new OrderProducts();
                $order_product->order_id = $order->id;
                $order_product->product_id = $product_id;
                $order_product->product_name = $product->name;
                // $order_product->user_order_id = $user_order->id;
                $order_product->product_qty = array_key_exists("in_cart", $reqProduct) ? $reqProduct['in_cart'] : 1;
                $order_product->product_unit_price = $product->price;
                $order_product->product_type = 'size';
                $order_product->product_total_price = $product->price;
                $order_product->product_subtotal = $product->price;
                $order_product->product_options = json_encode($optionData);
                $order_product->save();
            }else{
                $order_product->product_qty += array_key_exists("in_cart", $reqProduct) ? $reqProduct['in_cart'] : 1;
                $order_product->save();
            }



            $order->subtotal = $order->subtotal + $product->price + $optionPrice;
            $order->total = $order->total + $product->price + $optionPrice;
            $order->save();

            \DB::commit();
            return response()->json([
                "success" => true,
                "message" => "Updated Successfully",
                "order_id" => $order->id
            ], Response::HTTP_OK);

        }catch(\Exception $e){
            \DB::rollback();
            throw $e;
        }
    }


    public function addCustomProductToOrder(Request $request){

        $order_id = $request->order_id;

        $order = Order::findOrFail($order_id);

        $optionData = [];

        $reqProduct = json_decode($request->product, true) ?: [];
        if(array_key_exists("custom_size", $reqProduct) && $reqProduct['custom_size'] && count($reqProduct['custom_size']) > 0){
            foreach ($reqProduct['custom_size'] as $csize) {
                foreach ($csize['custom_group'] as $cgroup) {
                    $d = [];
                    $d['options'] = [];
                    foreach($cgroup['options'] as $options){
                        if($options['is_checked'] == true){
                            array_push($d['options'], [
                                'option_id' => $options['id'],
                                'option_name' => \App\Models\Option::find($options['id'])?->name,
                                'price' => $options['price'],
                            ]);
                        }
                    }
                    if(count($d['options']) > 0){
                        $d['group_id'] = $cgroup['id'];
                        $d['group_name'] = \App\Models\OptionGroup::find($cgroup['id'])?->name;
                        $d['size_id'] = $csize['id'];
                        $d['size_name'] = \App\Models\Size::find($csize['id'])?->name;
                        array_push($optionData, $d);
                    }
                }
            }
        }else if(array_key_exists("custom_group", $reqProduct)){
            foreach ($reqProduct['custom_group'] as $cgroup) {
                $d = [];
                $d['options'] = [];
                foreach($cgroup['options'] as $options){
                    if($options['is_checked'] == true){
                        array_push($d['options'], [
                            'option_id' => $options['id'],
                            'option_name' => \App\Models\Option::find($options['id'])?->name,
                            'price' => $options['price'],
                        ]);
                    }
                }
                if(count($d['options']) > 0){
                    $d['group_id'] = $cgroup['id'];
                    $d['group_name'] = \App\Models\OptionGroup::find($cgroup['id'])?->name;
                    $d['size_id'] = null;
                    $d['size_name'] = null;
                    array_push($optionData, $d);
                }
            }
        }


        $order_product          = new OrderProducts();
        $order_product->order_id = $order->id;
        $order_product->product_id = null;
        $order_product->product_name = $request->product_name;
        // $order_product->user_order_id = $user_order->id;
        $order_product->product_qty = 1;
        $order_product->product_unit_price = $request->price;
        $order_product->product_type = 'size';
        $order_product->product_total_price = $request->price;
        $order_product->product_subtotal = $request->price;
        $order_product->product_options = json_encode($optionData);
        $order_product->save();

        $order->subtotal = $order->subtotal + $request->price;
        $order->total = $order->total + $request->price;
        $order->save();

        return response()->json([
            "success" => true,
            "message" => "Updated Successfully",
        ], Response::HTTP_OK);
    }




    public function payByGlobalGift(Request $request){

        $user = User::findOrFail($request->user_id);
        $order = Order::findOrFail($request->order_id);

        if($order->status == Order::STATUS_PAID){
            return response()->json([
                "status" => "fail",
                "message" => "Order is already paid"
            ], 500);
        }

        $tip = 0;
        if($request->tip_id){
            $tipObj = Tip::where('company_id', $order->company_id)->where('id', $request->tip_id)->first();
            $tip = ($order->subtotal * ($tipObj?->tip / 100));
        }


        $total = $order->total + $tip;
        $original_total = $order->total + $tip;


        // Apply Global Gift Credit First
        $claim_repo = new DiscountClaimRepository();
        $global_credit_amount = $claim_repo->remainginGlobalCredit($user->id);

        if($global_credit_amount > 0){
            if($global_credit_amount >= $total){
                $order->used_global_credit = $total;
                $order->status = Order::STATUS_PAID;
                $order->tips = $tip;
                $order->total = $order->total + $tip;
                $order->save();
                $claim_repo->createGlobalUsedDiscountEntry($user , $order->id , $total, $order->company_id);
                $total = 0;
            }else{
                $order->used_global_credit = $global_credit_amount;
                $order->tips = $tip;
                $order->total = $order->total + $tip;
                $order->save();

                $claim_repo->createGlobalUsedDiscountEntry($user , $order->id , $global_credit_amount, $order->company_id);
                $total = $total - $global_credit_amount; // remaining total after partial payment with global credit
            }
        }

        if($total > 0){

            $egift_amount = Egift::where('user_id', $user->id)->sum("gift_amount");
            $used_egift = UsedEgift::where('user_id', $user->id)->sum("used_amount");
            $egift_balance = $egift_amount - $used_egift;

            if($egift_balance > 0){

                if($egift_balance >= $total){
                    $order->status = Order::STATUS_PAID;
                    $order->used_egift = $total;
                    $order->save();
                    $total = 0;
                }else{
                    $order->used_egift = $egift_balance;
                    $order->save();
                    $total = $total - $egift_balance;
                }

                UsedEgift::create([
                    "company_id" => $order->company_id,
                    "order_id" => $order->id,
                    'user_id' => $user->id,
                    "used_amount" => $order->used_egift,
                ]);
            }
        }

        if($total == $original_total){
            return response()->json([
                "status" => "failed",
                "message" => "Payment Failed"
            ], 500);
        }else{
            return response()->json([
                "status" => "success",
                "message" => "Payment Successful"
            ], 200);
        }


    }


    public function orderCompanyDetails($order_id){

        $order = Order::find($order_id);
        $company = Company::where('id', $order->company_id)->first();

        return new CompanyResource($company);
    }

    public function sendOrderVerificationOtp(Request $request){

        $hidden_code = $request->hidden_code;
        $dial_code = $request->dial_code;
        $phone_number = $request->phone_number;
        $phone_number = str_replace(' ', '', $phone_number);
        $phone_number = str_replace('-', '', $phone_number);
        $phone_number = str_replace('(', '', $phone_number);
        $phone_number = str_replace(')', '', $phone_number);

        $phone_number = $dial_code.$phone_number;

        $is_sent = Helper::sendSMS($phone_number, "Your verification code is $hidden_code Never share this code");

        if ($is_sent) {
            return response()->json(true, 200);
        } else {
            return response()->json(false, 422);
        }

    }
}
