<?php

namespace App\Http\Controllers\Api\V11;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Transaction;
use Carbon\Carbon;

class PayoutController extends Controller
{
    public function payoutBalance(){

        $user = auth()->user();
        $company = $user->company;

        $payout_days = $company->payouts_days;
        $date  = Carbon::now()->subDays($payout_days)->format('Y-m-d');

        $available_balance = Transaction::where('company_id', $company->id)
                    ->whereDate('created_at', '<=', $date)
                    ->where('type', Transaction::FOOD_ORDER)
                    ->where('is_payout', 0)->sum('amount');

        $pending_balance = Transaction::where('company_id', $company->id)
            ->whereDate('created_at', '>', $date)
            ->where('type', Transaction::FOOD_ORDER)
            ->where('is_payout', 0)->sum('amount');

        

        return response()->json([
            "pending_balance" => $pending_balance,
            "available_balance" => $available_balance
        ], 200);
        
    }
}
