<?php

namespace App\Http\Controllers\Api\V11;

use App\Http\Controllers\Controller;
use App\Http\Resources\ProductOptionGroupResource;
use App\Http\Resources\ProductResource;
use App\Http\Resources\ProductSizeResource;
use App\Models\Product;
use App\Models\ProductOptionGroup;
use App\Models\ProductPrice;
use Illuminate\Http\Request;

class ProductController extends Controller
{
    public function companyProductList(Request $request, $company_id)
    {
      
        $request->validate([
            'category_id' => 'nullable|numeric',
            'menu_id' => 'nullable|numeric',
            'name'       => 'nullable'
        ]);
    
        $query = Product::where("company_id", $company_id);

        if($request->filled('category_id')){
            $query->where('products.category_id', $request->category_id);
        }
        if($request->filled('menu_id')){
            $query->where('products.menu_type_id', $request->menu_id);
        }
        
        $products = $query->paginate(request('per_page', 10));

        return ProductResource::collection($products);
      
    }

    public function singleProduct($product_id){

        $product = Product::find($product_id);
        return new ProductResource($product);

    }


    public function productVariations($product_id){

        $product = Product::findOrFail($product_id);

        $custom_size = count($product->customSize) ? ProductSizeResource::collection($product->customSize, $product->customGroup) : [];
        $custom_group = !count($product->customSize) ? ProductOptionGroupResource::collection($product->customGroup) : [];

        return response()->json([
            "custom_size" => $custom_size,
            "custom_group" => $custom_group
        ]);

    }


}
