<?php

namespace App\Http\Controllers\Api\V11;

use App\Http\Controllers\Controller;
use App\Http\Resources\TableListResource;
use Illuminate\Http\Request;
use App\Http\Resources\TableReservationResource;
use App\Models\Company;
use App\Models\CustomerReservations;
use App\Models\Order;
use App\Models\Table;

class ReservationController extends Controller
{

    public function reserveTable(Request $request){

        $request->validate([
            'company_id'  => 'required|integer|exists:companies,id',
            'user_id'     => 'required|integer|exists:users,id',
            'party_size'  => 'required|numeric|min:1',
            // 'datetime'    => 'required|date_format:Y-m-d H:i:s|after_or_equal:now',
        ]);

        // $datetime = $request->pick_date." ".$request->pick_time;
        // $datetime = date('Y-m-d H:i',strtotime($datetime));

        $user_id = request('user_id');

        $datetime       =  date('Y-m-d H:i',strtotime($request->datetime));
        $reservation    =  CustomerReservations::where('customer_id', $user_id)
            ->whereRaw("DATE_FORMAT(datetime, '%Y-%m-%d %H:%i') = '$datetime'")
            ->first();

        if($reservation){
            return response()->json([
                'message'       => 'Table is already assigned to reservation.',
                'reservation'   =>  $reservation
            ], 400);
        }

        $reservation                =   new CustomerReservations();
        $reservation->status        =   CustomerReservations::STATUS_NEW;
        $reservation->customer_id   =   $user_id;
        $reservation->company_id    =   $request->company_id;
        $reservation->party_size    =   $request->party_size;
        $reservation->datetime      =   date('Y-m-d H:i:s',strtotime($request->datetime));
        $reservation->notes         =   $request->notes ? $request->notes :NULL;
        $reservation->save();

        return response()->json([
        'message'       => 'Table reserved Successfully.',
        'reservation'   =>  $reservation
        ], 200);
    }


    public function reservedTables($company_id){
        $user_id = request('user_id');
        // $company_id = request('company_id');
        $perPage = request('per_page', 10);
        $reservations = CustomerReservations::with('customer','company','table')
                // ->where('customer_id', $user_id)
                ->where('company_id', $company_id)
                ->paginate($perPage);
        
        return TableReservationResource::collection($reservations);
    }

    public function assignTableToReservation(Request $request){

        $reservation_id = $request->reservation_id;
        $table_id = $request->table_id;

        if(auth('sanctum')->user()){

            $company = Company::find(auth('sanctum')->user()->company ? auth('sanctum')->user()->company->id:-1);
            if(empty($company)){
                return response()->json([ 'message' => 'Company not found.' ], 400);
            }

            $table = Table::where('id',$table_id)->where('company_id',$company->id)->first();
            if(empty($table)){
                return response()->json([ 'message' => 'Table not found.' ], 400);
            }

            $reservationtable = CustomerReservations::with('company','customer','table')->where('table_id',$table_id)->where('company_id',$company->id)->where('status',CustomerReservations::STATUS_ASSIGNED)->first();
            if($reservationtable){
                return response()->json([
                    'message'       => 'Table is already assigned to an other reservation.',
                    'reservation'   =>  $reservationtable
                ], 400);
            }


            $reservation = CustomerReservations::with('company','customer','table')->where('id',$reservation_id)->where('company_id',$company->id)->whereIn('status',[CustomerReservations::STATUS_NEW,CustomerReservations::STATUS_ASSIGNED])->first();
            if(empty($reservation)){
                return response()->json([ 'message' => 'Reservation not found.' ], 400);
            }
            if($reservation && $reservation->status == CustomerReservations::STATUS_ASSIGNED){
                return response()->json([
                    'message'       => 'Table is already assigned to reservation.',
                    'reservation'   =>  $reservation
                ], 400);
            }
            // $tableorder  =   Order::whereNotNull('table_id')
            //                     ->where('orders.company_id',$company->id)
            //                     ->where('orders.table_id',$table_id)
            //                     ->whereRaw("( 
            //                                     orders.status IN (0,2) 
            //                                     OR 
            //                                     (orders.status = 1 AND orders.table_area_type = 'pickup' AND orders.is_pickup_confirmed IS NULL) 
            //                                 )")
            //                     ->first();
            // if($tableorder){
            //     return response()->json([
            //         'message'       => 'Table not available.',
            //         'tableorder'    =>  $tableorder
            //     ], 400);
            // }
            $reservation->table_id  =    $table_id;
            $reservation->status    =    CustomerReservations::STATUS_ASSIGNED;
            $reservation->save();
            return response()->json([
                'message'       => 'Table is assigned to reservation.',
                'reservation'   =>  $reservation
            ], 200);
        }
        else{
            return response()->json([
                'message' => (['Unauthenticated User'])
            ], 400);
        }
    }

    public function tableList($company_id, Request $request)
    {
        $request->validate([
            'area_id' => 'nullable|numeric',
        ]);

        $query = Table::select('id','area_id','name','seats')
                    ->where('company_id', $company_id);

        if($request->filled('area_id')){
            $query->where('area_id', $request->area_id);
        }

        // $query->with('area');
        
        $tables = $query->get();

        return TableListResource::collection($tables); 
        // return response()->json([
        //     'tables' => $tables, 
        // ],200);
      
    }

    public function activeReservation(Request $request){
        
        $company_id = $request->company_id;
        $order_id = $request->order_id;
        $reservation = CustomerReservations::with('customer','company','table')
            // ->where('customer_id', $user_id)
            ->where('company_id', $company_id)
            ->where('order_id', $order_id)->first();

        return new TableReservationResource($reservation);
    }
}
