<?php

namespace App\Http\Controllers\Api\V11;

use App\Http\Controllers\Controller;
use App\Http\Resources\UserResource;
use App\Models\User;
use Illuminate\Http\Request;
use Auth;

class UserController extends Controller
{
    public function getUserByPhone(Request $request){

        $dial_code = $request->dial_code;
        $dial_code = str_replace('+', '', $dial_code);
        
        
        $phone_number = $request->dial_code.$request->phone_number;
        $phone_number = str_replace('-', '', $phone_number);

        $user = User::where("phone_number", $phone_number)->first();
        
        return new UserResource($user);

    }


    public function getUserByBarcode(Request $request){

        $phone_number = $request->phone_number;
        $phone_number = str_replace('-', '', $phone_number);

        $user = User::where("phone_number", $phone_number)->first();
        return new UserResource($user);

    }


    public function sign_in(Request $request)
    {
        $data = $request->validate([
            'email' => 'required|email',
            'password' => 'required'
        ]);

        if (!Auth::attempt($data)) {
            return response()->json([
                'message' => 'Email & Password does not match with our record',
                "errors" => [
                    "email" => ["Email & Password does not match with our record"],
                    "password" => ["Email & Password does not match with our record"],
                ]
            ], 401);
        }

        $user = User::where('email', $request->email)->first();
        $latestUnreadNotification = false;//$user->unreadNotifications()->latest()->first();
        if ($latestUnreadNotification) {
            return response()->json([
                'message' => "Please verify user to login",

            ])->setStatusCode(400);
        } else {
            return response()->json([
                'user_id' => $user->id,
                'user_name' => $user->name,
                // 'company' => ($user->company) ? true : false,
                'company_id' => ($user->company) ? $user->company->id : null,
                'company_name' => ($user->company) ? $user->company->name : null,
                'token' =>  $user->createToken('apiToken')->plainTextToken,
            ]);
        }
    }


}
