<?php

namespace App\Http\Controllers\BusinessApp;

use App\Http\Controllers\Controller;
use App\Models\Area;
use Illuminate\Http\Request;

class AreaController extends Controller
{
    public function index()
    {
        $areas = Area::where('company_id', auth()->user()->company->id)->paginate(20);
        return view('business-app.area.index', compact('areas'));
    }

    public function create()
    {
        return view('business-app.area.create');
    }

    public function store(Request $request){

        $request->validate([
            'name' => 'required',
            'type' => 'required',
        ]);

        Area::create([
            'company_id' => auth()->user()->company->id,
            'name' => $request->name,
            'type' => $request->type,
        ]);

        return redirect()->route('area.index')->with("success", "Area Created Successfully!");
    }

    public function edit($area_id)
    {
        $area = Area::where('id', $area_id)->where('company_id', auth()->user()->company->id)->first();
        return view('business-app.area.edit', compact('area'));
    }

    public function update($area_id, Request $request){

        $request->validate([
            'name' => 'required',
            'type' => 'required',
        ]);

        $area = Area::where('id', $area_id)->where('company_id', auth()->user()->company->id)->first();

        $area->update([
            'name' => $request->name,
            'type' => $request->type,
        ]);

        return redirect()->route('area.index')->with("success", "Area Updated Successfully!");
    }

    public function destroy($area_id){

        $area = Area::where('id', $area_id)->where('company_id', auth()->user()->company->id)->first();
        
        $area->delete();
        
        return redirect()->route('area.index')->with("success", "Area Deleted Successfully!");

    }
}
