<?php

namespace App\Http\Controllers\BusinessApp;

use App\Http\Controllers\Controller;
use App\Models\Category;
use Illuminate\Http\Request;

class CategoryController extends Controller
{
    public function index()
    {
        $categories = Category::where('company_id', auth()->user()->company->id)->root()->paginate(20);

        return view('business-app.category.index', compact('categories'));
    }

    public function create()
    {
        $menutypes = auth()->user()->company->menuTypes;
        return view('business-app.category.create', compact('menutypes'));
    }

    public function store(Request $request){

        $request->validate([
            'menutype' => 'required',
            'name' => 'required'
        ]);

        $filename = null;
        if($request->image){
            $filename = $request->image->hashname();
            $request->image->storeAs('public/category', $filename);
        }

        Category::create([
            'company_id' => auth()->user()->company->id,
            'menu_id' => $request->menutype,
            'name' => $request->name,
            'image' => $filename
        ]);

        return redirect()->route('category.index')->with("success", "Category Created Successfully!");

    }

    public function edit($id)
    {
        $category = Category::where('id', $id)->where('company_id', auth()->user()->company->id)->first();
        $menutypes = auth()->user()->company->menuTypes;
        return view('business-app.category.edit', compact('category', 'menutypes'));
    }

    public function update($id, Request $request){

        $request->validate([
            'menutype' => 'required',
            'name' => 'required',
        ]);

        $category = Category::where('id', $id)->where('company_id', auth()->user()->company->id)->first();

        $filename = null;
        if($request->image){
            $filename = $request->image->hashname();
            $request->image->storeAs('public/category', $filename);
        }

        $category->update([
            'menu_id' => $request->menutype,
            'name' => $request->name,
            'image' => $filename
        ]);

        return redirect()->route('category.index')->with("success", "Category Updated Successfully!");
    }

    public function destroy($id){

        $category = Category::where('id', $id)->where('company_id', auth()->user()->company->id)->first();

        $category->delete();

        return redirect()->route('category.index')->with("success", "Category Deleted Successfully!");

    }
}
