<?php

namespace App\Http\Controllers\BusinessApp;

use App\Models\CustomerStripeInfo;
use App\Models\Company;
use App\Notifications\PhoneVerificationCode;
use App\Nova\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\CompanyType;
use App\Models\RegularGiftSetting;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Log;
use Illuminate\Validation\Validator;

class CompanyController extends Controller
{
    public function index($id)
    {
        $company = auth()->user()->company;
        $company_types = CompanyType::all();
        return view('business-app.company', compact('company', 'company_types'));
    }

    public function updateSettings(Request $request){

        $request->validate([
            'company_name' => 'required',
            'address_line_1' => 'required',
            'address_line_2' => 'nullable',
            'reservation_fee' => 'nullable',
            'reservation_before' => 'nullable',
            'cancelation_fee' => 'nullable',
            'postal_code' => 'required',
        ]);

        $company = auth()->user()->company;

        $company->update([
            'type_id' => $request->type_id,
            'name' => $request->company_name,
            'address_line_1' => $request->address_line_1,
            'address_line_2' => $request->address_line_2,
            'reservation_fee' => $request->reservation_fee,
            'cancelation_fee' => $request->cancelation_fee,
            'postal_code' => $request->postal_code,
        ]);
       
        return redirect()->back()->with("success", "Settings Updated Successfully");
    }

    public function terms($id)
    {
        $company = Company::with('fullowner')->where('id',$id)->first();
        if (!Gate::allows('update-company', $company->owner_id)) {
            abort(403);
        }
        return view('business-app.company-terms',compact('company'));
    }
    public function addPhone(Request $request,$user_id){
        $user_phone = $request->userPhoneCode.$request->userPhoneNumber;
        $user_phone = str_replace('+','',$user_phone);
        $dupplicat  = \App\Models\User::where('phone_number','LIKE',$user_phone)->withTrashed()->where('id','!=', $user_id)->count();
        if($dupplicat == 0){
            $user   = \App\Models\User::where('id', $user_id)->first();
            $user->phone_number = $user_phone;
            $user->save();
            return response()->json([
                'status' => 'success',
                'msg'    => 'Phone number is added successfully.'
            ],200);
        }else{
            return response()->json([
                'status' => 'error',
                'msg'    => 'Phone number is already used.'
            ],200);
        }

    }
    public function sendOTP(Request $request,$user_id){

        try {
            $user   = \App\Models\User::where('id', $user_id)->first();
            if(!$user || is_null($user->phone_number) || $user->phone_number == ''){
                return response()->json([
                    'status' => 'error',
                    'msg'    => 'Invalid Phone number',
                ],200);
            }

            $random_number = rand(1000, 9999);
            session()->put("otp", $random_number);
            
            $is_sent = Helper::sendSMS($user->phone_number, "Your verification code is $random_number Never share this code");

            return response()->json([
                'status' => 'success',
                'msg'    => 'OTP sent successfully'
            ],200);
        }
        catch (\Throwable $th) {
            return response()->json([
                'status' => 'error',
                'msg'    => 'Invalid Phone number',
                'ex'    =>  $th->getMessage()
            ],200);
        }
    }

    public function verifyOtp(Request $request,$user_id){

        $notify = DB::table('notifications')->where('notifiable_id',$user_id)->latest('created_at')->first();
        if($notify){
            $otp            =   $request->otp;
            $verfication_no =   json_decode($notify->data)->verfication_no;
            if($otp == $verfication_no){
                $user                        = \App\Models\User::where('id', $user_id)->first();
                $user->verified_agreement_at = date('Y-m-d H:i:s');
                $user->save();
                DB::table('notifications')->where('notifiable_id',$user_id)->update(['read_at'=>NOW() ]);
                return response()->json([
                    'status' => 'success',
                    'msg'    => 'Phone number verified successfully'
                ],200);
            }else{
                return response()->json([
                    'status' => 'error',
                    'msg'    => 'Please enter valid OTP',
                ],200);
            }
        }else{
            return response()->json([
                'status' => 'error',
                'msg'    => 'Invalid Request',
            ],200);
        }

    }

   
}
