<?php

namespace App\Http\Controllers\BusinessApp;

use App\Http\Controllers\Controller;
use App\Models\Menu;
use App\Models\Product;
use App\Models\ProductOptionGroup;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;

class ProductControllerOrig extends Controller
{
    public function index()
    {
        return view('business-app.product');
    }

    public function store(Request $request)
    {
        $validaion = Validator::make($request->all(), [
            'product_id' => 'nullable|string',
            'category_id' => 'required',
            'menu_id' => 'required',
        ]);
        if ($validaion->fails()) {
            return back()->withErrors($validaion->errors());
        }
        try {
            if (!$request->product_id) {
                $product = $this->storeProduct($request);
            } else {
                $product = $this->updateStore($request);
            }
            $this->storeSize($request->all(), $product);
            return redirect()->back()->with(['message' => 'Updated successfully']);
        } catch (\Exception $exception) {
            return redirect()->back()->with(['error' => 'Something went wrong !']);
        }
    }

    private function updateStore($request)
    {
        try {
            $pro = Product::find($request->product_id);
            if ($request->menu_id) {
                $pro->menu_id = $request->menu_id;
                $pro->menu_type_id = Menu::find($request->menu_id)->menu_type_id;
            }
            if ($request->category_id)
                $pro->category_id = $request->category_id;
            if ($request->price)
                $pro->prices = (['price' => $request->price]);
            $path = '';
            if ($request->image) {
                if ($pro->image) {
                    unlink($pro->image);
                }
                $temp = $request->image->store('product/images', 'public');
                $path = env('APP_URL') . '/storage/' . $temp;
            }
            $options = [
                'name' => $request->name ?? ($pro->name ?? ''),
                'description' => $request->description ?? ($pro->description ?? ''),
                'product_image' => $path
            ];
            $pro->options = ($options);
            $pro->save();
            return $pro;
        } catch (Exception $exception) {
            dd($exception);
        }
    }

    private function storeProduct($request)
    {
        try {
            $pr = new Product();
            $pr->category_id = $request->category_id;
            if ($request->menu_id) {
                $pr->menu_id = $request->menu_id;
                $pr->menu_type_id = Menu::find($request->menu_id)->menu_type_id;
            }
            $pr->prices = (['price' => $request->price]);
            $path = '';
            if ($request->image) {
                $temp = $request->image->store('product/images', 'public');
                $path = env('APP_URL') . '/storage/' . $temp;
            }
            $options = [
                'name' => $request->name ?? '',
                'description' => $request->description ?? '',
                'product_image' => $path
            ];
            $pr->options = ($options);
            $pr->save();
            return $pr;
        } catch (Exception $exception) {
            dd($exception);
        }
    }

    private function storeSize($request, $product)
    {
        try {
            $output = [];
            $group = [];
            $options = [];
            $i = 0;
            $size = $request['selectType'] == 'size' ? true : false;
            foreach (collect($request['extra'])->toArray() as $item) {
                if (isset($size)) {
                    if (isset($item["size"]) && count($item["size"])) {
                        $output[] = array(
                            "size_id" => $item["size"]["name"] ?? null,
                            "price" => $item["size"]["price"] ?? null
                        );
                    }
                }
                if (count($output))
                    $product->customSize()->attach($output);

                if (count($item['group'])) {
                    $k = 0;
                    foreach ($item['group'] as $groupTd) {
                        if (isset($groupTd["group_name"]) && isset($groupTd["group_price"])) {
                            $group[] = array(
                                "option_group_id" => $groupTd["group_name"],
                                "upto" => $groupTd["group_price"],
                                "size_id" => isset($output[$k]["size_id"]) ? $output[$k]["size_id"] : null,
                                "is_required" => isset($groupTd["group_required"]) ? ($groupTd["group_required"] == "on" ? 1 : 0) : 0,
                            );
                        }
                        $k++;
                    }
                }
                $i++;
            }
            if (count($group))
                $product->customGroup()->attach($group);

            if (isset($request['options'])) {
                if (count($request['options'])) {
                    foreach ($request['options'] as $itemNew) {
                        $l = 0;
                        foreach ($itemNew["sdjl"] as $key => $optionsItem)
                            foreach ($optionsItem as $value) {
                                foreach ($value as $nValue) {
                                    if (isset($nValue)) {
                                        $options[] = array(
                                            "product_option_group_id" => ProductOptionGroup::where('option_group_id', $key)
                                                    ->where('product_id', $product->id)
                                                    ->first()->id ?? null,
                                            "option_id" => $nValue,
                                        );
                                    }
                                }
                            }
                    }
                    $l++;
                }
            }
            if (count($options))
                $product->customOptions()->sync($options, true);
        } catch (Exception $exception) {
            dd($exception);
        }
    }

}
