<?php

namespace App\Http\Controllers\BusinessApp;

use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Models\Table;
use Illuminate\Http\Request;

class TableController extends Controller
{
    public function index()
    {
        $tables = Table::where('company_id', auth()->user()->company->id)->paginate(20);
        return view('business-app.table.index', compact('tables'));
    }

    public function create()
    {
        $areas = auth()->user()->company->areas;
        return view('business-app.table.create', compact('areas'));
    }

    public function store(Request $request){

        $request->validate([
            'area' => 'required|integer',
            'name' => 'required',
            'seats' => 'required|integer',
            'type'  => 'required|string',

        ]);

        Table::create([
            'company_id' => auth()->user()->company->id,
            'area_id' => $request->area,
            'name' => $request->name,
            'seats' => $request->seats,
            'type' => $request->type,
        ]);

        return redirect()->route('table.index')->with("success", "Table Created Successfully!");

    }

    public function edit($id)
    {
        $table = Table::where('id', $id)->where('company_id', auth()->user()->company->id)->first();
        $areas = auth()->user()->company->areas;

        return view('business-app.table.edit', compact('table', 'areas'));
    }

    public function update($id, Request $request){

        $request->validate([
            'area' => 'required|integer',
            'name' => 'required',
            'seats' => 'required|integer',
            'type'  => 'required|string',
        ]);

        $table = Table::where('id', $id)->where('company_id', auth()->user()->company->id)->first();

        $table->update([
            'area_id' => $request->area,
            'name' => $request->name,
            'seats' => $request->seats,
            'type' => $request->type,
        ]);

        return redirect()->route('table.index')->with("success", "Table Updated Successfully!");
    }

    public function destroy($id){

        $table = Table::where('id', $id)->where('company_id', auth()->user()->company->id)->first();

        $table->delete();

        return redirect()->route('table.index')->with("success", "Table Deleted Successfully!");

    }
}
