<?php

namespace App\Http\Controllers\BusinessApp;

use App\Http\Controllers\Controller;
use App\Models\Tax;
use Illuminate\Http\Request;

class TaxController extends Controller
{
   
    public function index()
    {
        $taxes = Tax::where('company_id', auth()->user()->company->id)->get();
        $tax =Tax::where('company_id', auth()->user()->company->id)->first();
        return view('business-app.tax.index', compact('taxes', 'tax'));
    }

    public function create(){
        
        return view('business-app.tax.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'tax' => 'required',
        ]);

        Tax::create([
            'company_id' => auth()->user()->company->id,
            'tax' => $request->tax,
        ]);

        return redirect()->route('tax.index')->with("success", "Tax Created Successfully!");
    }

    public function update($tax_id, Request $request){

        $t = Tax::where('id', $tax_id)->where('company_id', auth()->user()->company->id)->first();
        $t->tax = $request->tax;
        $t->save();

        return redirect()->route('tax.index')->with("success", "Tax Updated Successfully!");
    }
}
