<?php

namespace App\Http\Controllers;

use App\Models\Company;
use App\Models\CompanyType;
use Illuminate\Http\Request;

class GuestController extends Controller
{
    public function showBusinessSignUp(){
        $company_types = CompanyType::all();
        return view("business-signup", compact("company_types"));
    }

    
    public function claim($company_id){

        $company = Company::find($company_id);
        if(!$company_id || !$company){
            abort(404);
        }

        return view('claim', compact('company_id'));
    }


    public function tempBusiness(){

        $companies = Company::where('company_type', 'temp')->get();
        return view('temp-business', compact('companies'));
    }
}
