<?php

namespace App\Http\Controllers;

use App\Models\Api\V1\CustomerStripeInfo;
use App\Models\Cart;
use App\Models\Category;
use App\Models\Company;
use App\Models\CustomerReservations;
use App\Models\Order;
use App\Models\OrderProducts;
use App\Models\Product;
use App\Models\UserOrder;
use App\Repositories\DiscountClaimRepository;
use Illuminate\Http\Request;
use Auth;
use App\Models\Discount;
use Cartalyst\Stripe\Stripe;
use App\Models\Transaction;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Redirect;

class MyCompanyController extends Controller
{
    public function index($company_id){
        $company = Company::findOrFail($company_id);
        $company_categories = Category::has('products')->where('company_id', $company_id)->get();
        if($company->business_timezone){
            date_default_timezone_set($company->business_timezone);
        }
        $company_products = [];
        $first_category = null;
        if(count($company_categories) > 0){
            $first_category = $company_categories[0];
            $company_products = Product::where('company_id', $company_id)->where('category_id', $first_category->id)->paginate(10);
        }

        $claim_repo = new DiscountClaimRepository();
        $active_discount = $claim_repo->getActiveDiscount($company_id);

        if(Auth::check()){
            $can_claim = $claim_repo->canClaim(auth('sanctum')->user(),$company_id);
        }else{
            $can_claim = false;
        }

        // \Cookie::queue('company', $company->id, 2628000);
        session()->put('company_id', $company->id);


        $discount = Discount::where('company_id', $company_id)->first();

        // if(!$discount) abort(404);

        $startsAt = strtotime($discount?->pt_starts_at);

        if($discount?->pt_type == "now"){
            $endsAt = strtotime("+$discount?->pt_total_hours hours", $startsAt);
            $startsAt = time();
        }else if($discount?->pt_type == "schedule"){
            if(time() >= $startsAt){ //schedule time started
                $endsAt = strtotime("+$discount?->pt_total_hours hours", $startsAt);
            }else{
                $endsAt = strtotime($discount?->pt_starts_at); // show how much time left to start
            }
        }else if($discount?->pt_type == "prize_hour"){
            
            $dayNumber = date('N', strtotime('now'));
            $disHour = $discount?->discount_hours()->where("day", $dayNumber)->first();

            $startsAt = $disHour?->starts_at ?  strtotime(strftime("%F") . ' ' .$disHour->starts_at) : null;
            $endsAt = $disHour?->ends_at ?  strtotime(strftime("%F") . ' ' .$disHour->ends_at) : null;

            $look_for_next = true;
            if($startsAt && time() <= $startsAt){
                $look_for_next = false;
            }else if($startsAt && $endsAt && time() >= $startsAt && time() <= $endsAt){
                $look_for_next = false;
            }

            if($look_for_next == true){
                $disHours = $discount?->discount_hours()->orderBy("day", 'asc')->get();
                if(count($disHours)  > 0){
                    $disHour = $disHours[0];
                    for($i = 1; $i < count($disHours); $i++){
                        if($disHours[$i]->day > $dayNumber){
                            $disHour = $disHours[$i];
                            break;
                        }
                    }
                    $dayDiff = $dayNumber > $disHour->day ? $dayNumber - $disHour->day : $disHour->day - $dayNumber;
                    // $startsAt = strtotime(" + $dayDiff days");
                    $dayDiff = $dayDiff + 1;

                    $startsAt = strtotime(strftime("%F") . ' ' .$disHour->starts_at." + $dayDiff days");
                    $endsAt = strtotime(strftime("%F") . ' ' .$disHour->ends_at." + $dayDiff days");
                 
                }
            }
            
        }else{
            $endsAt = time() - 1;
        }

        $percentage = 0;
        $percentage_off = $discount?->terms;

        if($percentage_off >= 10 && $percentage_off <= 25){
            $percentage = 95;
        }else if($percentage_off > 25 && $percentage_off <= 30){
            $percentage = 90;
        }else if($percentage_off > 30 && $percentage_off <= 50){
            $percentage = 85;
        }else if($percentage_off > 50 && $percentage_off <= 90){
            $percentage = 80;
        }

        $dt = new \DateTime();
        if($company->business_timezone){
            $dt->setTimezone(new \DateTimeZone($company->business_timezone));
        }
        $countdownTime = isset($endsAt) ? $dt->setTimestamp($endsAt)->format("Y/m/d H:i:s") : '';

        $user = Auth::user();
        $remainingDiscount = 0;
        if($user){
            $remainingDiscount = $claim_repo->remaingDiscountAmount($user, $discount, $company_id);
        }

        return view('company-details', compact('company', 'remainingDiscount', 'countdownTime', 'discount', 'percentage', 'endsAt', 'startsAt', 'company_products', 'can_claim','company_categories', 'first_category', 'active_discount'));
    }

    public function reserveTable($company_id)
    {
        $company = Company::findOrFail($company_id);

        $dayNumber = date('N', strtotime('now'));
        // $dayNumber = 1;
        $dayToAdd = 0;

        $totalBusinessHours = $company->businesshours()->count();
        $business_hours = [];
        if($totalBusinessHours > 0){
            $business_hours = $company->businesshours()->where('day', $dayNumber)->orderBy('from', 'asc')->get();
            while(count($business_hours) <= 0){
                $dayToAdd += 1;
                $dayNumber = $dayNumber + 1;
                if($dayNumber >= 7) $dayNumber = 1;
                $business_hours = $company->businesshours()->where('day', $dayNumber)->orderBy('from', 'asc')->get();
            }
        }
        
        // $startHour = $business_hours[0]->from;
        // $endHour = $business_hours[count($business_hours) - 1]->to;

        // $sh = strtotime(strftime("%F") . ' ' .$startHour);
        // $eh = strtotime(strftime("%F") . ' ' .$endHour);
        
        // $slots = [];
        // while($sh < $eh){
        //     $end = $sh + 15 * 60;
        //     array_push($slots, [
        //         "start" => $sh,
        //         "end" => $end
        //     ]);
        //     $sh = $end;
        // }

        $reservation = null;
        if(Auth::check()){
            $reservation    =  CustomerReservations::where('customer_id', Auth::user()->id)
                ->where('company_id', $company->id)
                ->where("status", '<=',CustomerReservations::STATUS_ASSIGNED)
                ->first();

                $temp_user_id = request()->temp_user_id;
                if(!$temp_user_id) $temp_user_id = session()->get("temp_user_id");
                $cartItems = Cart::where('temp_user_id', $temp_user_id)->get();
                
                if($reservation && count($cartItems) > 0){
            
                    $user = Auth::user();
                    
                    if(!$reservation->order_id){
                        $order      =   $user->orders()->create([
                            'status'            =>  Order::STATUS_NEW,
                            'type'              =>  0,
                            'company_id'        =>  $reservation->company_id,
                            'employee_id'       =>  null,
                            'user_id'           =>  $user->id,
                            'table_id'          =>  null,
                            'table_area_type'   =>  'table',
                            'subtotal'          =>  0,
                        ]);
            
                        $user_order = $order->userOrders()->create([
                            'order_id' => $order->id,
                            'status' => 0,
                            'user_id' => $user->id,
                            'company_id' => $order->company_id,
                            // 'products' => json_encode($request->products),
                            'subtotal' => 0,
            //                'tax' => $request->tax ? $request->tax : 0,
                            'tips' => 0,
                            'discount' => 0,
            //                'total'    =>  ($order->subtotal - $request->discount + ((($order->subtotal - $request->discount) * $request->tax) / 100) + $request->tips)
                        ]);
        
                        $reservation->order_id = $order->id;
                        $reservation->save();
                    }else{
                        $order = Order::find($reservation->order_id);
                        $user_order = UserOrder::where('order_id', $order->id)->first();
                    }
        
                    
                    foreach ($cartItems as $cartItem) {
                        $product = $cartItem->product;
                        
                        $order_product          = new OrderProducts();
                        $order_product->product_id = $product->id;
                        $order_product->user_order_id = $user_order->id;
                        $order_product->product_qty = $cartItem->quantity;
                        $order_product->product_unit_price = $product['prices']['price'];
                        $order_product->product_type = 'size';
                        $order_product->product_total_price = $cartItem->quantity * $product['prices']['price'];
                        $order_product->product_subtotal = $order_product->product_total_price;
                        $order_product->product_options = $cartItem->option_data;
                        $order_product->save();
                        
                    }
        
                    $subtotal               =   OrderProducts::where('user_order_id', $user_order->id)->sum('product_subtotal');
                    UserOrder::where('id', $user_order->id)->update([
                        'products'  =>  [],
                        'subtotal'  =>  $subtotal,
                        'total'     =>  $subtotal
                    ]);
        
                    Cart::where('temp_user_id', $temp_user_id)->delete();
        
                    Order::where('id', $user_order->order_id)->update([
                        'products'  =>  [],
                        'subtotal' => $subtotal
                    ]);
        
                }

            if($reservation && $reservation->order && $reservation->order->status == Order::STATUS_PAID){
                // $reservation = null;
            }else if($reservation && $reservation->order){

                return Redirect::to("/order/$reservation->order_id?reservation_id=$reservation->id");
            }
        }

        

        return view('reserve-table', compact('company', 'business_hours', 'dayToAdd', 'reservation'));

    }

    public function saveReserveTable(Request $request){

        $request->validate([
                'company_id'  => 'required|integer|exists:companies,id',
                'party_size'  => 'required|numeric|min:1',
                'pick_time'  => 'required',
                // 'pick_date'    => 'required',
                // 'pick_time'    => 'required',
        ]);

        // $datetime = $request->pick_date." ".$request->pick_time;
        // $datetime = date('Y-m-d H:i',strtotime($datetime));
        $date = $request->pick_date;
        $time = date('H:i', $request->pick_time);
        $datetime = null;
        if($request->pick_date && $request->pick_time){
            $datetime = "$date $time";
        }

        if(auth('sanctum')->user()){
            // $datetime       =  date('Y-m-d H:i',strtotime($request->datetime));
            $reservation    =  CustomerReservations::where('customer_id',auth('sanctum')->user()->id)
                                    ->where('status', '<=', CustomerReservations::STATUS_ASSIGNED)
                                    ->whereRaw("DATE_FORMAT(datetime, '%Y-%m-%d %H:%i') = '$datetime'")
                                    ->first();
            if($reservation){
                return redirect()->back()->with("error", 'You already have reservation in this time');
            }

            $reservation                =   new CustomerReservations();
            $reservation->status        =   CustomerReservations::STATUS_NEW;
            $reservation->customer_id   =   auth('sanctum')->user()->id;
            $reservation->company_id    =   $request->company_id;
            $reservation->party_size    =   $request->party_size;
            $reservation->datetime      =   $datetime;
            $reservation->notes         =   $request->note ? $request->note :NULL;
            $reservation->save();
    
            return redirect()->back()->with("success", 'Reservation created successfully');
        }
        else{

            session()->put('reserve_party_size', $request->party_size);
            session()->put('reserve_pick_date', $request->pick_date);
            session()->put('reserve_pick_time', $request->pick_time);
            session()->put('reserve_note', $request->note);
            return Redirect::to("/sign-in");
            // return redirect()->back()->with("error", 'Please Login First to reserve.');
        }
    }

    public function showCheckout($company_id){

        $temp_user_id = session()->get("temp_user_id");
        $carts = \App\Models\Cart::where('temp_user_id', $temp_user_id)->get();
        if(count($carts) <= 0){
            return redirect()->back();
        }
        return view('checkout', compact('carts', 'company_id'));
    }

    public function productDetails($product_id){

        $product = Product::find($product_id);

        return view('product-details', compact('product'));
    }

    public function userLogin(){
        
        return view('user-login');
    }

    public function userRegister(){
        
        return view('user-register');
    }

    public function cancelReservation(Request $request)
    {
        $id = $request->id;
        $reservation = CustomerReservations::find($id);
        $reservation->status = CustomerReservations::STATUS_CANCELLED;
        $reservation->save();

        return redirect()->back()->with("success", "Rservation Cancelled");
    }

    public function companyList(){

        $companies      =   Company::where('business_active', 1)->get();
        return view('company-list', compact('companies'));
    }

    public function buyOffers($company_id){

        // $res = Http::get("https://maps.googleapis.com/maps/api/place/details/json?place_id=ChIJN1t_tDeuEmsRUsoyG83frY4&key=AIzaSyDwNQg9sgVAaC2eTRZJE6n2YCbOJOjEigQ");
        // dd($res->body());
        $company = Company::findOrFail($company_id);
        $discount = Discount::where('company_id', $company_id)->first();

        if(!$discount) abort(404);

        $startsAt = time();
        $originalStartsAt = null;

        if($discount->pt_type == "now"){
            $originalStartsAt = $startsAt;
            $endsAt = strtotime("+$discount->pt_total_hours hours", $startsAt);
        }else if($discount->pt_type == "schedule"){
            $originalStartsAt = strtotime($discount->pt_starts_at);
            if(time() >= $originalStartsAt){ //schedule time started
                $endsAt = strtotime("+$discount->pt_total_hours hours", $startsAt);
            }else{
                $endsAt = strtotime($discount->pt_starts_at); // show how much time left to start
            }
        }else if($discount->pt_type == "prize_hour"){
            $dayNumber = date('N', strtotime('now'));
            $disHour = $discount->discount_hours()->where("day", $dayNumber)->first();
            if($disHour){
                $originalStartsAt = strtotime(strftime("%F") . ' ' .$disHour->starts_at);
                if(time() >= $originalStartsAt){
                    $endsAt = strtotime(strftime("%F") . ' ' .$disHour->ends_at);
                }else{
                    $endsAt = strtotime(strftime("%F") . ' ' .$disHour->starts_at);
                }
            }else{
                $endsAt = time() - 1;
            }
        }else{
            $endsAt = time() - 1;
        }


        // if($startsAt > $endsAt) abort(404);


        $can_claim = false;
        $claim_repo = new DiscountClaimRepository();
        $user = Auth::user();
        if($user){
            $can_claim = $claim_repo->canClaim($user,$company_id);
        }

        $percentage = 0;
        $percentage_off = $discount->terms;

        if($percentage_off >= 10 && $percentage_off <= 25){
            $percentage = 95;
        }else if($percentage_off > 25 && $percentage_off <= 30){
            $percentage = 90;
        }else if($percentage_off > 30 && $percentage_off <= 50){
            $percentage = 85;
        }else if($percentage_off > 50 && $percentage_off <= 90){
            $percentage = 80;
        }

        return view("buy-offers", compact("company", "originalStartsAt","discount", "startsAt", "endsAt", "can_claim", "percentage"));
    }

    public function payToBuyOffers(Request $request){

        $discount = Discount::findOrFail($request->discount_id);

        $user = Auth::user();
        $customer_stripe_info = CustomerStripeInfo::where('customer_id', $user->id)->first();

        $customer_stripe_customer_id = $customer_stripe_info->stripe_cus_id;
        $customer_stripe_payment_id = $customer_stripe_info->stripe_pm_id;
        $chargeResult = $this->chargePayment($discount, $customer_stripe_customer_id , $customer_stripe_payment_id);

        if($chargeResult == true){
            return redirect()->back()->with('success', "Discount bought successfully");
        }else{
            return redirect()->back()->with('error', "Failed");
        }
    }

    public function chargePayment($discount, $customer_stripe_customer_id , $customer_stripe_payment_method_id)
    {

        $claim_repo = new DiscountClaimRepository();
        $user = Auth::user();
        if (!$claim_repo->canClaim($user,$discount->company_id)) {
            return redirect()->back()->with("error", "Failed to Claim");
        }
     
        $stripe = new Stripe(config('services.stripe.secret'));

        $paymentIntent = $stripe->paymentIntents()->create([
            'amount' => $discount->pt_paying_amount,
            'currency' => 'usd',  
            'customer' => $customer_stripe_customer_id,
            'payment_method' => $customer_stripe_payment_method_id,
            // 'off_session' => true,
            'confirm' => true,
        ]);

        if (!empty($paymentIntent) && $paymentIntent["status"] == "succeeded") {
    
            $transaction = Transaction::create([
                'user_id' => $user->id,
                'charge_id' => $paymentIntent["charges"]["data"][0]["id"],
                'type' => Transaction::BUY_DISCOUNT,
                'company_id' => $discount->company_id,
                'amount' => $discount->pt_paying_amount,
                'payment_intent_id' => $paymentIntent["id"]
            ]);

            
            $claim_repo->createClaim($user,$discount->company_id);
                 
            return true;
        }

        return false;
    }
}
