<?php

namespace App\Http\Middleware;

use App\Models\User;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Auth;

class AuthorizationMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if($request->is("user/*") && Auth::check()){
            $user = Auth::user();
            if($user->type != User::TYPE_CUSTOMER){
                abort(Response::HTTP_UNAUTHORIZED);
            }
        }else if($request->is("business-app/*") && Auth::check()){
            $user = Auth::user();
            if($user->type != User::TYPE_BUSINESS){
                if($user->is_admin == false){
                    abort(Response::HTTP_UNAUTHORIZED);
                }
            }
        }else if($request->is("admin/*") && Auth::check()){
            $user = Auth::user();
            if($user->is_admin != 1){
                abort(Response::HTTP_UNAUTHORIZED);
            }
        }
        
        return $next($request);
    }
}
