<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class UniqueIdGenerator
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $unique_id = \Cookie::get("unique_id");
        if(!$unique_id){
            $unique_id = Str::random(32);
            $expireAt = time() + 60 * 60 * 24 * 365;
            \Cookie::queue('unique_id', $unique_id, $expireAt, null, null, false, false);
        }

        return $next($request);
    }
}
