<?php

namespace App\Http\Requests\Company;

use Illuminate\Foundation\Http\FormRequest;

class StoreCompanyRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            "contact_person_name" => ["required", "string", "max: 200"],
            "company_name" => ["required", "string", "max: 200"],
            "company_type" => ["required"],
            "email" => ["required", "email", "unique:users"],
            "password" => ["required"],
            "phone_number" => ["required", "unique:users"],
            "business_address" => ["required", "string", "max: 200"],
            "business_latitude" => ["required"],
            "business_longitude" => ["required"],
        ];
    }
}
