<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CartResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            "id" => $this->id,
            "name" => $this->name,
            "price" => "$".$this->price,
            "quantity" => $this->quantity,
            "total" => "$".$this->price * $this->quantity,
            "product_image" => $this->product->product_image ?: asset('assets/images/placeholder.png'),
            "product_id" => $this->product_id,
            "company_id" => $this->company_id,
            "option_data" => json_decode($this->option_data)
        ];
    }
}
