<?php

namespace App\Http\Resources;

use App\Models\Product;
use Illuminate\Http\Resources\Json\JsonResource;

class CategoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $products = [];
        if($request->with_products){
            $p = Product::where('category_id', $this->id)->get();
            $products = ProductResource::collection($p);
        }

        return [
            "id" => $this->id,
            "company_id" => $this->company_id,
            "category_id" => $this->category_id,
            "menu_id" => $this->menu_id,
            "name" => $this->name,
            "image_url" => $this->image ? url('storage/category/'.$this->image) : null,
            "products" => $products,
            "created_at" => $this->created_at,
            "updated_at" => $this->updated_at,
        ];
    }
}
