<?php

namespace App\Http\Resources;

use App\Http\Resources\Company\CompanyTypeResource;
use Illuminate\Http\Resources\Json\JsonResource;

class CompanyMenuTypeResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            "id" => $this->id,
            "name" => $this->name,
            "company_types" => CompanyTypeResource::collection($this->company_types)
        ];
    }
}
