<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class DiscountResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            "id" => $this->id,
            "company_name" => $this->company?->name,
            "name" => $this->name,
            "status" => $this->status,
            "pause_discount" => "no",
            "starts_at" => $this->starts_at?->format("Y-m-d\TH:i:s"),
            "ends_at" => $this->ends_at?->format("Y-m-d\TH:i:s"),
            "credit_amount" => $this->amount,
            "limit_claims" => $this->max_users,
            "maximum_discount" => $this->max_discount_per_order,
            "total_number_of_discount" => $this->total_no_of_discounts,
            "percentage_off" => $this->terms,
            "prime_time" => $this->pt_type,
            "prime_starts_at" => $this->pt_starts_at,
            "prime_total_hours" => $this->pt_total_hours,
            "prime_percentage_off" => $this->pt_percentage,
            "pay_amount" => $this->pt_paying_amount,
            "is_global" => $this->is_global ? true : false,
            "prize_hours" => $this->discount_hours
        ];
    }
}
