<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class GlobalDiscountResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {

        $current_hour = date("H");
        $show_discount_type = "";
        if($current_hour == 0){
            $show_discount_type = "regular";
            $cycle = 2; // putting even value for regular
        }else{
            // 2/2=1
            // 4/2 =2
            // 6/2 = 3
            // 8/2 =4
            // 10/2=5
            // 12/2=6
            // 14/2=7
            $cycle = $current_hour / 2;
            $show_discount_type = $cycle % 2 == 0 ? "regular" : "deal";
        }

        $secondsLeftTillNextHour = Carbon::now()->endOfHour()->diffInSeconds(Carbon::now());
        $countdown_time = $secondsLeftTillNextHour;
        if($current_hour % 2  == 0){
            $countdown_time = $secondsLeftTillNextHour + 3600;
        }

        $show_amount = $this->credit_amount - ($this->credit_amount * ($this->show_discount / 100));


        $price = $show_discount_type == "deal" ? $this->deal_price : $this->regular_price;
        $save_now = $this->credit_amount - $price;

        return [
            "id" => $this->id,
            "credit_amount" => $this->credit_amount,
            "discount" => $show_discount_type == "deal" ? $this->deal_discount : $this->regular_discount,
            "price" => $price,
            "regular_discount" => $this->regular_discount,
            "regular_price" => $this->regular_price,
            "deal_discount" => $this->deal_discount,
            "deal_price" => $this->deal_price,
            "show_discount_type" =>  $show_discount_type,
            "countdown_time" => $countdown_time,
            "show_discount" => $this->show_discount,
            "show_price" => $show_amount,
            "save_now" => number_format((float)$save_now, 2, '.', '')
        ];
    }
}
