<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class OrderItemResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $odata = [];

        $orderOptions = json_decode($this->product_options ?? "[]");

        foreach ($orderOptions as $opt) {
            $size = \App\Models\Size::where('id', $opt->size_id)->first();
            $pprice = \App\Models\ProductPrice::where('size_id', $opt->size_id)->first();
            $optionGroup = \App\Models\OptionGroup::where('id', $opt->group_id ?? "")->first();
            $options = \App\Models\Option::whereIn('id', is_array($opt->options) ? array_column($opt->options, "option_id") : [])->get();

            $data = [];
            $data['group_name'] = $optionGroup?->name;
            $data['options'] = [];
            foreach ($options as $op) {
                array_push($data['options'], [
                    "id" => $op->id,
                    "option_name" => $op->name,
                    "option_price" => $op->price,
                    "size" => $size ? $size->name : null
                ]);
            }
            array_push($odata, $data);
        }


        $product_image = $this->product?->product_image;

        return [
            "id" => $this->id,
            "product_name" => $this->product ? $this->product->name ?? "" : $this->product_name ?? "",
            "product_image" => $product_image ? asset("/storage/".$product_image) : null,
            "quantity" => $this->product_qty,
            "product_price" => $this->product_unit_price,
            "options" => $odata
        ];
    }
}
