<?php

namespace App\Http\Resources;

use App\Models\Product;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductFormation extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $output = [
            "id" => $this->id,
            "category_id" => $this->category_id,
            "prices" => $this->prices,
            "options" => $this->options,
            "menu" => $this->menu,
            "toppings" => $this->toppings,
            'custom_size' => count($this->customSize) ? sizeResource::collection($this->customSize,$this->customGroup) : [],
            'custom_group' => groupResource::collection($this->customGroup)
        ];
        return $output;
    }
}

class sizeResource extends JsonResource
{
    private $sample;

    public function __construct($resource, $sample)
    {
        parent::__construct($resource);
        $this->sample = $sample;
    }

    public function toArray($request)
    {
        $group = Product::with(['customGroup.options'])
            ->where('id', $this->pivot->product_id)
            ->first();
        return [
            "id" => $this->id,
            "company_id" => $this->company_id,
            "name" => $this->name,
            'price' => $this->price,
            'pivot' => $this->pivot,
            'custom_group' => groupResource::collection($group->customGroup),
        ];
    }
}

class groupResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            "id" => $this->id,
            "company_id" => $this->company_id,
            "name" => $this->name,
            'pivot' => $this->pivot,
            'options' => OptionResource::collection($this->whenLoaded('options')),
        ];
    }
}

class OptionResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            "id" => $this->id,
            "company_id" => $this->company_id,
            "option_group_id" => $this->option_group_id,
            "name" => $this->name,
            "price" => $this->price,
        ];
    }
}
