<?php

namespace App\Http\Resources;

use App\Models\Product;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductSizeResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $group = Product::with(['customGroup.options'])
            ->where('id', $this->pivot->product_id)
            ->first();

        return [
            "id" => $this->id,
            "company_id" => $this->company_id,
            "name" => $this->name,
            'price' => $this->price,
            'pivot' => $this->pivot,
            'custom_group' => ProductOptionGroupResource::collection($group->customGroup),
        ];
    }
}
