<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class TableReservationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            "id" => $this->id,
            "status" => $this->status,
            "customer_id" => $this->customer_id,
            "customer_name" => $this->customer?->name,
            "customer_phone" => $this->customer?->phone_number,
            "party_size" => $this->party_size,
            "datetime" => date('m/d h:iA', strtotime($this->datetime)),
            "table_id" => $this->table_id,
            "table_name" => $this->table?->name,
            "order_id" => $this->order_id,
            "notes" => $this->notes,
        ];
    }
}
