<?php

namespace App\Http\Resources;

use App\Models\Order;
use Illuminate\Http\Resources\Json\JsonResource;

class TipResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $tipAmount = 0;
        if($request->order_id){
            $order = Order::find($request->order_id);
            $orderedItems = $order->orderProducts;
            $optionTotal = 0;
    
            foreach ($orderedItems as $orderedItem) {
                $optionTotal += $orderedItem->quantity * $orderedItem->price;
    
                $orderOptions = json_decode($orderedItem->product_options);
                foreach ($orderOptions as $copt){
                    foreach ($copt->options as $op){
                        $optionTotal += $op->price ?? 0; 
                    }
                }
                
            }
    
            $subtotal = $order->subtotal + $optionTotal;
            $tipAmount = $subtotal * ($this->tip / 100);
        }

        return [
            "id" => $this->id,
            "tip_percentage" => $this->tip,
            "tip_amount" => number_format((float)$tipAmount, 2, '.', '')
        ];
    }
}
