<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Discount extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $fillable = [
        'company_id',
        'status',
        'name',
        'starts_at',
        'ends_at',
        'terms',
        'max_users',
        'max_amount',
        'amount',
        'max_discount_per_order',
        'total_no_of_discounts',
        "pt_type",
        "pt_starts_at",
        "pt_total_hours",
        "pt_percentage",
        "pt_paying_amount",
        "is_global"
    ];

    protected $casts = [
        'starts_at' => 'datetime',
        'ends_at' => 'datetime',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class, 'company_id');
    }

    public function scopeWihoutCompleted($query)
    {
        $query->where('status', '!=', 'completed');
    }

    public function discount_hours(){
        return $this->hasMany(DiscountHour::class);
    }
}
