<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class File extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function fileable()
    {
        $this->morphTo();
    }

    protected function name(): Attribute
    {
        return Attribute::make(
            get: fn ($value) => asset('storage').'/'.$value,
        );
    }

}
