<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Follow extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = "followers";

    protected $casts = [
        'company_id' => 'integer',
        'follower' => 'integer',
        'followed' => 'integer',
        'status' => 'integer',
    ];
    protected $guarded = [];

    protected $fillable = [
        'company_id',
        'follower',
        'followed',
        'status',
];
}
