<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrderProductSizes extends Model
{
    use HasFactory;
    protected $table    =   "order_product_sizes";
    protected $guarded  =   [];

    public function size()
    {
        return $this->belongsTo(Size::class)->select('id','name');
    }

    public function productSizeOptionGroups(){
        return $this->hasMany(OrderProductGroupOptions::class,'size_id');
    }
}
