<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrderProducts extends Model
{
    use HasFactory;
    protected $table = 'order_products';
    protected $guarded = [];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function productSizes(){
        return $this->hasMany(OrderProductSizes::class,'product_id');
    }
    public function productOptionGroups(){
        return $this->hasMany(OrderProductGroupOptions::class,'product_id')->whereNull('size_id');
    }

}
