<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductOptionGroup extends Model
{
    // use SoftDeletes;
    use HasFactory;

    protected $guarded;

    protected $fillable = [
        'product_id',
        "option_group_id",
        "upto",
        "size_id",
        "is_required",
    ];


    public function options()
    {
        return $this->hasMany(ProductOption::class,'product_option_group_id');
    }

    public function myoption(){
        return $this->belongsTo(OptionGroup::class);
    }

    // public function user(){
    //     return $this->belongsTo('App\Models\OptionGroup','option_group_id','id');
    // }

}
