<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductPrice extends Model
{
    // use SoftDeletes;
    use HasFactory;

    protected $fillable = [
        "product_id",
        "size_id",
        "price"
    ];


    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function size()
    {
        return $this->belongsTo(Size::class);
    }


    public function options()
    {
        return $this->belongsToMany(OptionGroup::class,'options','product_price_id','option_group_id');
    }
}
