<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Storage;

class PromoType extends Model
{
    use HasFactory;

    const TYPE_DISCOUNT = 'advantage';
    const TYPE_HOMELESS = 'claim';
    const TYPE_SCHOOL = 'third_party';
    const TYPE_COMMUNITY = 'regular';
    const TYPE_SOMEONE = 'someone';
    const TYPE_OTHER = 'manually';
    const GIFT = 'gift';
    const DONATION = 'donation';
    const REGULAR = 'regular';
    const Transfer = 'transfer';

    protected $table = 'promo_types';

    protected $guarded = [];

    public function promo()
    {
        return $this->belongsTo(Promo::class, 'promo_id');
    }

    public function userPromos()
    {
        return $this->hasMany(UserPromo::class);
    }

    public function amountSum($refresh = false)
    {
        $key = "promo-type-$this->id-amount-sum";
        if (!$refresh && Cache::has($key)) return Cache::get($key);
        $sum = $this->userPromos()->completed()->sum('amount');
        Cache::put($key, $sum);
        return $sum;
    }

    public function totalSum($refresh = false)
    {
        $key = "promo-type-$this->id-total-sum";
        if (!$refresh && Cache::has($key)) return Cache::get($key);
        $sum = $this->userPromos()->completed()->sum('total');
        Cache::put($key, $sum);
        return $sum;
    }

    public function url()
    {
        return '/promo/buy/' . $this->id;
    }

    public function img()
    {
        return $this->files ? Storage::url($this->files) : (config('app.url') . '/profi/images/image-29.jpg');
    }

    public function discountBy($amount)
    {
        return $amount * $this->discount / 100;
    }

    public function totalBy($amount)
    {
        return $amount - $this->discountBy($amount);
    }

    public function updateSold()
    {
        $this->sold = $this->userPromos()->completed()->count();
        $this->save();
    }
}
