<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RegularGiftSetting extends Model
{

    const PERCANTAGE_TO_BUYER = 0;
    const DISCOUNT_TO_ORDER = 1;
    use HasFactory;
    protected $fillable = [
        'company_id',
        'gift_amount_1',
        'gift_amount_2',
        'gift_amount_3',
        'discount',
        'discount_limit',
        'expire_at',
        'for_some_one',
        'discount_type',
        'discount_limit_value',
        'discount_someone',
        'is_regular_free',
        'receipent_will_get',
        'buyer_will_get_first_time',
        'buyer_will_get_second_time',
    ];


    public function discountBy($amount)
    {
        $discount = 0;
        if (empty($this->expire_at) || $this->expire_at > Carbon::now()) {
            $discount = $this->discount;
        }

        $user_get = $amount * $discount / 100;
        if ($this->discount_limit && $this->discount_limit > 0 && $this->discount_limit < $user_get) {
            $user_get = $this->discount_limit;
        }
        return $user_get;
    }

    public function totalBy($amount)
    {
        return $amount - $this->discountBy($amount);
    }

    public function percantageUserGet($amount)
    {
        $user_get = 0;
        if (empty($this->expire_at) || $this->expire_at > Carbon::now()) {
            $user_get = $this->discount_someone;
        }
        $user_get = $amount * $user_get / 100;
        if ($this->discount_limit_value > 0 && $this->discount_limit_value < $user_get) {
            $user_get = $this->discount_limit_value;
        }
        return $user_get;
    }

    public function discountOrderBy($amount)
    {
        $discount = 0;
        if (empty($this->expire_at) || $this->expire_at > Carbon::now()) {
            $discount = $this->discount_someone;
        }
        $discount = $amount * $discount / 100;
        if ($this->discount_limit_value > 0 && $this->discount_limit_value < $discount) {
            $discount = $this->discount_limit_value;
        }
        return $discount;
    }

    public function totalOrderPay($amount)
    {
        return $amount - $this->discountOrderBy($amount);
    }
}
