<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Size extends Model
{
    use SoftDeletes;
    use HasFactory;

    protected $fillable = [
        'company_id',
        'name',
        'price'
    ];

    public function company()
    {
        return $this->belongsTo(Company::class, 'company_id');
    }


    public function products()
    {
        return $this->belongsToMany(Product::class, 'product_prices', 'size_id', 'product_id');
    }

    public function customGroup()
    {
        return $this->hasManyThrough(
            ProductOptionGroup::class,
            ProductPrice::class,
            'product_id',
            'product_id',
        );
    }

    public function sizeGroup()
    {
        return $this->belongsToMany(OptionGroup::class, ProductOptionGroup::class);
    }
}