<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    use HasFactory;

    const TYPE_GIFT_CARD = 'gift-card';
    const FOOD_ORDER = 'food-order';
    const TYPE_UO_TERMINAL = 'uo-terminal';
    const TYPE_UO_CASH = 'uo-cash';
    const TYPE_UO_CARD = 'uo-card';
    const REGULAR_GIFT = 'regular';
    const PROMO_USE = 'promo-use';
    const REFUND_ORDER = 'refund';
    const BUY_DISCOUNT = 'discount';
    const TYPE_E_GIFT = 'e-gift';
    const IS_PAYOUT = 1;
    
    protected $guarded = [];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function userOrder()
    {
        return $this->belongsTo(UserOrder::class);
    }

    public function userPromo()
    {
        return $this->belongsTo(UserPromo::class);
    }

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    public function scopeByPaymentIntent($query, $id)
    {
        return $query->where('payment_intent_id', $id);
    }

    public function scopeTerminal($query)
    {
        return $query->where('type', self::TYPE_UO_TERMINAL);
    }

    public function scopeCash($query)
    {
        return $query->where('type', self::TYPE_UO_CASH);
    }

    public function scopeCard($query)
    {
        return $query->whereIn('type', [self::TYPE_UO_CARD, self::FOOD_ORDER]);
    }

    public function scopeGifCard($query)
    {
        return $query->where('type', self::TYPE_GIFT_CARD);
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }
}
