<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserOrder extends Model
{
    use HasFactory, SoftDeletes;

    const STATUS_NEW = 0;
    const STATUS_PAID = 1;
    const STATUS_CANCELED = 2;

    protected $table = 'user_order';

    protected $guarded = [];

    protected $casts = [
        'products' => 'array'
    ];

    public function setProductAttribute($value)
    {
        $properties = [];

        foreach ($value as $array_item) {
            if (!is_null($array_item['key'])) {
                $properties[] = $array_item;
            }
        }

        $this->attributes['products'] = json_encode($properties);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function transactions()
    {
        return $this->hasMany(Transaction::class);
    }

    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    public function usedDiscount()
    {
        return $this->hasMany(UsedDiscounts::class);
    }

    public function promoUses()
    {
        return $this->hasMany(PromoUse::class);
    }

    public function scopeNotPaid($query){
        return $query->where('status', '!=', self::STATUS_PAID);
    }

    public function scopeActive($query){
        return $query->whereIn('status', [ self::STATUS_NEW, self::STATUS_PAID ]);
    }

    public function getPromoUseCentsAttribute(){
        return $this->promoUses()->sum('amount');
    }


    public function getTerminalPaymentsCentsAttribute(){
        return $this->transactions()->terminal()->sum('amount');
    }

    public function getCashPaymentsCentsAttribute(){
        return $this->transactions()->cash()->sum('amount');
    }

    public function getCardPaymentsCentsAttribute(){
        return $this->transactions()->card()->sum('amount');
    }

    public function getAmountToPayAttribute(){
        return $this->subtotal + $this->tax + $this->tips - $this->discount;
    }

    public function getTerminalPaymentsAttribute(){
        return $this->terminal_payments_cents / 100;
    }

    public function getCashPaymentsAttribute(){
        return $this->cash_payments_cents / 100;
    }

    public function getCardPaymentsAttribute(){
        return $this->card_payments_cents / 100;
    }

    public function getPromoUseAttribute(){
        return $this->promo_use_cents / 100;
    }


//    public function getUsedDiscountAttribute(){
//        return $this->usedDiscount()->sum('amount');
//    }

    public function getAmountPaidAttribute(){
        return $this->promo_use + $this->card_payments + $this->cash_payments + $this->terminal_payments;// + $this->used_discount;
    }

    public function getTotalCentsAttribute(){
        return $this->total * 100;
    }

    public function calculate(){
        $this->total = round($this->amountToPay - $this->amountPaid, 2);
       
    }

//    public function isPaid(){
//        return $this->amountToPay <= $this->amountPaid;
//    }

    public function isPaid(){

        $amountToPay  =   "{$this->amountToPay}";
        $amountPaid   =   "{$this->amountPaid}";
        return $amountToPay <= $amountPaid ? true:false;
    }

    public function isStatusPaid(){
        return $this->status == self::STATUS_PAID;
    }
    public function orderProducts(){
        return $this->hasMany(OrderProducts::class);
    }

}
