<?php

namespace App\Nova\Actions;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Collection;
use Laravel\Nova\Actions\Action;
use Laravel\Nova\Fields\ActionFields;
use Laravel\Nova\Fields\BelongsTo;
use Laravel\Nova\Fields\Select;
use Laravel\Nova\Fields\Email;
use Laravel\Nova\Fields\Boolean;
use Laravel\Nova\Fields\Text;
use Laravel\Nova\Fields\Currency;
use Laravel\Nova\Http\Requests\NovaRequest;
use Laravel\Nova\Fields\FormData;
use App\Models\Promo as PromoModel;
use App\Nova\Promo;
use App\Models\UserPromo;

class AddUserGiftCard extends Action
{
    use InteractsWithQueue, Queueable;

    public function handle(ActionFields $fields, Collection $models)
    {
        try {
            $userPromo = UserPromo::from($fields->toArray());
        }catch(\Exception $e){
            return Action::danger($e->getMessage());
        }

        if($userPromo){
            return Action::message('Action is in development');
        }else{
            return Action::danger('Card has not been created');
        }
    }

    public function fields(NovaRequest $request)
    {
        return [

            Select::make('Type', 'type')
                ->options([
                    'regular' => 'Regular',
                    'condigion' => 'Condition',
                    'location' => 'Location Condition'
                ])
                ->displayUsingLabels()
                ->default('regular'),

            Select::make('Location', 'promo')
                ->nullable()
                ->options(PromoModel::get()->mapWithKeys(function ($item, $key) {
                    return [$item->id => $item->address];
                })),

            Select::make('Card Type', 'promo_type')
                ->dependsOn(
                    [ 'promo' ],
                    function (Select $field, NovaRequest $request, FormData $formData) {
                        $promo = PromoModel::find($formData->promo);
                        $field->options($promo?->types->mapWithKeys(function ($item, $key) {
                            return [$item->id => $item->title . ' (' . $item->type . ')'];
                        }));
                    }
                )
                ->nullable(),

            Text::make('Phone Number', 'phone_number')
                ->help('In format: 12345678900 (with country code)'),

            Email::make('Email'),

            Text::make('First Name', 'first_name')
                ->help('(optional)'),

            Text::make('Last Name', 'last_name')
                ->help('(optional)'),

            Currency::make('Card Amount', 'amount')
        ];
    }
}
