<?php

namespace App\Nova;

use App\Models\UserPromo;
use Illuminate\Http\Request;
use Laravel\Nova\Fields\BelongsTo;
use Laravel\Nova\Fields\ID;
use Laravel\Nova\Fields\Number;
use Laravel\Nova\Http\Requests\NovaRequest;
use Vyuldashev\NovaMoneyField\Money;

class GiftCardSummary extends Resource
{
    /**
     * The model the resource corresponds to.
     *
     * @var class-string<\App\Models\GiftCardSummary>
     */
    public static $model = \App\Models\GiftCardSummary::class;
    public static $group = 'Gift Cards';
    public static function label(){ return 'Gift Cards Summary'; }

    /**
     * The single value that should be used to represent the resource when being displayed.
     *
     * @var string
     */
    public static $title = 'id';

    /**
     * The columns that should be searched.
     *
     * @var array
     */
    public static $search = [
        'id',
    ];

    /**
     * Get the fields displayed by the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function fields(NovaRequest $request)
    {
        return [
            ID::make()->sortable(),
            Number::make('Company ID', 'company_id')
                ->hideWhenCreating()
                ->hideWhenUpdating(),
            BelongsTo::make('Company')->searchable()
                ->hideWhenCreating()
                ->hideWhenUpdating(),
            Number::make('User ID', 'user_id')
                ->hideWhenCreating()
                ->hideWhenUpdating(),
            BelongsTo::make('User')->searchable()
                ->hideWhenCreating()
                ->hideWhenUpdating(),
            Money::make('total_balance')
                ->hideWhenCreating()
                ->hideWhenUpdating(),
        ];
    }

    /**
     * Get the cards available for the request.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function cards(NovaRequest $request)
    {
        return [];
    }

    /**
     * Get the filters available for the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function filters(NovaRequest $request)
    {
        return [];
    }

    /**
     * Get the lenses available for the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function lenses(NovaRequest $request)
    {
        return [];
    }

    /**
     * Get the actions available for the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function actions(NovaRequest $request)
    {
        return [];
    }



    public function authorizedToPerformActions(Request $request)
    {
        return false;
    }

}
