<?php

namespace App\Nova;

use Laravel\Nova\Fields\ID;
use Illuminate\Http\Request;
use Laravel\Nova\Fields\Text;
use Laravel\Nova\Fields\Number;
use Laravel\Nova\Fields\Select;
use Laravel\Nova\Fields\DateTime;
use Laravel\Nova\Fields\Code;
use Laravel\Nova\Fields\BelongsTo;
use Laravel\Nova\Fields\HasMany;
use Laravel\Nova\Fields\MultiSelect;
use Vyuldashev\NovaMoneyField\Money;
use Laravel\Nova\Http\Requests\NovaRequest;
use App\Models\Order as OrderModel;

class Order extends Resource
{
    /**
     * The model the resource corresponds to.
     *
     * @var string
     */
    public static $model = \App\Models\Order::class;

    public static $group = 'Orders';
    /**
     * The single value that should be used to represent the resource when being displayed.
     *
     * @var string
     */
    public static $title = 'id';

    /**
     * The columns that should be searched.
     *
     * @var array
     */
    public static $search = [
        'id', 'company', 'user',
    ];

    /**
     * Get the fields displayed by the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function fields(NovaRequest $request)
    {
        return [

            ID::make()->sortable(),

            Select::make('Status')->options([
                OrderModel::STATUS_NEW => 'New',
                OrderModel::STATUS_PAID => 'Paid',
                OrderModel::STATUS_ASSIGNED => 'Table Assigned',
                OrderModel::STATUS_CANCELED => 'Canceled',
            ])->rules('required')->displayUsingLabels(),

            Select::make('Type')->options([
                OrderModel::TYPE_DINE_IN => 'Dine in',
                OrderModel::TYPE_TAKE_OUT => 'Take Out',
                OrderModel::TYPE_RESERVATION => 'Reservation',
                OrderModel::TYPE_DELIVERY => 'Delivery',
            ])->rules('required')->displayUsingLabels(),

            BelongsTo::make('Company')->searchable()->nullable(),

            BelongsTo::make('User')->searchable()->nullable(),

            BelongsTo::make('Employee')->hideFromIndex()->nullable(),

            BelongsTo::make('Area')->searchable()->hideFromIndex()->nullable(),

            BelongsTo::make('Table')->searchable()->hideFromIndex()->nullable(),
            Text::make('Table ID', 'table_id')->showOnIndex()
                ->showOnDetail()
                ->hideWhenCreating()
                ->hideWhenUpdating(),
            Text::make('Table Area Type', 'table_area_type')->showOnIndex()
                ->showOnDetail()
                ->hideWhenCreating()
                ->hideWhenUpdating(),
            Text::make('Is confirm pickup', 'is_pickup_confirmed')->showOnIndex()
                ->showOnDetail()
                ->hideWhenCreating()
                ->hideWhenUpdating(),

            Code::make('Products')->rules('nullable', function($attribute, $value, $fail) {
                json_decode($value);
                if (json_last_error() !== JSON_ERROR_NONE) {
                    return $fail('The options field should be a valid JSON string.');
                }
            })->json(),
            Money::make('Number'),
            Money::make('Subtotal'),
            Money::make('Tax'),
            Money::make('Tips'),
            Money::make('Discount'),
            Money::make('Total'),
            DateTime::make('Created At')->sortable(),
            DateTime::make('Updated At')->hideFromIndex(),
            DateTime::make('Canceled At')->hideFromIndex(),

            HasMany::make('User Orders')
        ];
    }

    /**
     * Get the cards available for the request.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function cards(NovaRequest $request)
    {
        return [];
    }

    /**
     * Get the filters available for the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function filters(NovaRequest $request)
    {
        return [];
    }

    /**
     * Get the lenses available for the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function lenses(NovaRequest $request)
    {
        return [];
    }

    /**
     * Get the actions available for the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function actions(NovaRequest $request)
    {
        return [];
    }
}
