<?php

namespace App\Nova;

use Illuminate\Http\Request;
use Laravel\Nova\Fields\ID;
use Laravel\Nova\Fields\BelongsTo;
use Laravel\Nova\Fields\HasMany;
use Laravel\Nova\Fields\Number;
use Laravel\Nova\Fields\Text;
use Laravel\Nova\Fields\Select;
use Laravel\Nova\Http\Requests\NovaRequest;
use App\Models\UserPromo as UserPromoModel;

class UserPromo extends Resource
{
    /**
     * The model the resource corresponds to.
     *
     * @var string
     */
    public static $model = \App\Models\UserPromo::class;
    // protected$table = 'user_promo';
    public static $group = 'Gift Cards';
    public static function label(){ return 'User Gift Cards'; }

    /**
     * The single value that should be used to represent the resource when being displayed.
     *
     * @var string
     */
    public static $title = 'id';

    /**
     * The columns that should be searched.
     *
     * @var array
     */
    public static $search = [
        'id',
    ];

    /**
     * Get the fields displayed by the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function fields(NovaRequest $request)
    {
        return [
            ID::make()->sortable(),
            BelongsTo::make('Promo', 'promo', Promo::class)->searchable()->rules('required')->withOutTrashed(),
            BelongsTo::make('Promo Type', 'promoType', PromoType::class)->searchable()->rules('required')->withOutTrashed(),
            BelongsTo::make('User', 'user', User::class)->searchable()->rules('required')->withOutTrashed(),

            Select::make('Type')->options([
                'regular' => 'Regular',
                'condigion' => 'Condition',
                'location' => 'Location Condition'
            ])->displayUsingLabels(),

            Number::make('Amount', 'amount')->min(1)->rules('required')->help('In cents')->displayUsing(fn ($value) => '$' . number_format($value / 100, 2)),
            Number::make('Taxes', 'taxes')->min(1)->help('In cents')->displayUsing(fn ($value) => '$' . number_format($value / 100, 2)),
            Number::make('Total Claim', 'total_claim'),
            Number::make('Total', 'total')->min(1)->rules('required')->help('In cents')->displayUsing(fn ($value) => '$' . number_format($value / 100, 2)),
            Select::make('Status', 'status')->options([
                UserPromoModel::STATUS_NEW => 'New',
                UserPromoModel::STATUS_PROCESSING => 'Processing',
                UserPromoModel::STATUS_COMPLETED => 'Completed'
            ])->rules('required'),
            Select::make('Action', 'action')->options([
                UserPromoModel::PENDING => 'pending',
                UserPromoModel::DISAPPROVED => 'Disapprove',
                UserPromoModel::APPROVED => 'Approved'
            ])->rules('required'),
            Text::make('restaurant_type', 'restaurant_type'),
            Text::make('Order Code', 'order_code'),
            Number::make('Amount Avalilable', 'amount_available')->displayUsing(fn ($value) => '$' . number_format($value / 100, 2))->exceptOnForms(),

            BelongsTo::make('Transaction', 'transaction', Transaction::class)->nullable()->searchable()->showCreateRelationButton()->withOutTrashed(),

            HasMany::make('Promo Uses', 'promoUses', PromoUse::class)
        ];
    }


        public function summary()
    {
        return [
            Text::make('Value Amount', fn () => '$' . number_format($this->value, 2))->hideFromIndex(),
            Text::make('Amount Sum', fn () => '$' . number_format($this->amountSum() / 100, 2))->hideFromIndex(),
            Text::make('Total Sum (how much they paid)', fn () => '$' . number_format($this->totalSum() / 100, 2))
                ->hideFromIndex(),
            Text::make('Left', fn () => '$' . number_format($this->amountLeft(), 2))
                ->hideFromIndex(),
            Text::make('Status', function () {
                return $this->status == 0 ? "Coming Soon" : "New";
            })->hideFromIndex()

        ];
    }

    /**
     * Get the cards available for the request.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function cards(NovaRequest $request)
    {
        return [];
    }

    /**
     * Get the filters available for the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function filters(NovaRequest $request)
    {
        return [];
    }

    /**
     * Get the lenses available for the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function lenses(NovaRequest $request)
    {
        return [];
    }

    /**
     * Get the actions available for the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function actions(NovaRequest $request)
    {
        return [
            Actions\AddUserGiftCard::make()->standalone()
        ];
    }
}
