<?php

namespace App\Repositories;

use App\Models\Claim;
use App\Models\Promo;
use App\Models\PromoType;
use App\Models\User;
use App\Models\UserClaim;
use App\Models\UserPromo;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;

class ClaimGiftRepository
{

    public $promo = null;
    public $promo_found = true;
    public $show_claim = false;
    public $claim_limit = '';
    public $hypothetical_balance = 0;
    public $claim_setting_enable = 0;
    public $status;
    public $company_id;
    public $company_claim;
    public $expire_days = 0;
    public $expire_date;
    public $amount_claim = 0;
    public $first_user = 0;
    public $promoid = null;
    public $promo_type = null;
    public $success = null;


    public function getClaimAmount()
    {
        $company_claim = Claim::first();
        return ($company_claim) ? $company_claim->amount_claim : 0;
    }

    public function isAvailableClaim($companyID)
    {
        $this->setPromoInfo($companyID);
        if ($this->promo_found && $this->show_claim) {
            return true;
        }
        return false;
    }
    public function setPromoInfo($companyID)
    {
        $company_claim = Claim::first();
        $this->company_claim = $company_claim;
        $this->hypothetical_balance = ($company_claim) ? $company_claim->hypothetical_balance : 0;
        $this->claim_setting_enable = ($company_claim) ? $company_claim->claim_setting_enable : 0;
        $this->amount_claim = ($company_claim) ? $company_claim->amount_claim : 0;
        $this->expire_days = ($company_claim) ? $company_claim->expire_days : 0;
        $this->expire_date = ($company_claim) ? $company_claim->expire : 0;
        $this->first_user = ($company_claim) ? $company_claim->first_user : 0;

        if (Auth::user()) {
            $this->promo = Promo::where('company_id', $companyID)->where('status', 1)->first();
            if($this->promo){

                $claim_promo_type_chec = PromoType::where('type', 'claim')->where('promo_id', $this->promo->id)->first();

                $promo_balance =   UserPromo::where('promo_type_id', $claim_promo_type_chec->id)
                    ->where('user_id', auth()->user()->id)
                    ->where('type', 'claim')
                    ->where('promo_id', $this->promo->id)->first();

                if ($promo_balance) {
                    $amountAvailable = $promo_balance->getAmountAvailableAttribute();
                    // $amountAvailable = $amountAvailable / 100;
                    if (($amountAvailable + ($this->amount_claim  * 100)) > $this->first_user * 100) {
                        $this->promo_found = false;
                    }
                }
            }else{
                $this->promo_found = false;
            }

            if (Auth::user()->type == User::TYPE_CUSTOMER) {
                $userclaim_allowed = ($company_claim) ? $company_claim->user_claim_allowed : 0;
                $user_claims_count = UserClaim::where('user_id', auth()->user()->id)
                    // ->where('claim_id', $claim->id)
                    ->where('company_id', $companyID)
                    ->get()
                    ->count();
                if ($user_claims_count < $userclaim_allowed) {
                    $this->show_claim = true;
                } else {
                    $this->show_claim = false;
                }
            }
        }
    }
    public function claimGift($companyID)
    {
        $this->setPromoInfo($companyID);
        if (Auth::user()->type == User::TYPE_CUSTOMER) {
            $count = Claim::where('user_id', auth()->user()->id)
                ->where('company_id', $companyID)
                ->count();
            $claim = Claim::first();
            $user_claims_count = UserClaim::where('user_id', auth()->user()->id)
                ->where('claim_id', $claim->id)
                ->where('company_id', $companyID)
                ->get()
                ->count();

            if (($claim) && ($user_claims_count < $claim->user_claim_allowed)) {
                if ($claim->claim_per_day == 0) {
                    $this->promo = Promo::where('company_id', $companyID)->where('status', 1)->first();
                    $claim_promo_type_check = PromoType::where('type', 'claim')->where('promo_id', $this->promo->id)->first();

                    if (!$this->promo) {
                        // $this->claim_limit = "Company Promo Not found";
                        $this->promo_found = false;
                    } else {
                        $promo_balance =   UserPromo::where('promo_type_id', $claim_promo_type_check->id)
                            ->where('user_id', auth()->user()->id)
                            ->where('type', 'claim')
                            ->where('promo_id', $this->promo->id)->first();
                        // dd("gg".$promo_balance);
                        if ($promo_balance) {
                            $amountAvailable = $promo_balance->getAmountAvailableAttribute();
                            // dd($amountAvailable);
                            // $amountAvailable = $amountAvailable / 100;
                            // dd($claim->amount_claim);
                            // dd($amountAvailable + ($claim->amount_claim  * 100 ));
                            // dd($this->first_user * 100);
                            //  dd($amountAvailable + $claim->amount_claim  * 100  > $this->first_user * 100);
                            if (($amountAvailable + ($claim->amount_claim  * 100)) > $this->first_user * 100) {
                                // $this->claim_limit = 'Claim Balance limit exceeded';
                                // $this->emit('claim-event-warning', 'Claim Balance limit exceeded');
                            } else {
                                // dd("why");
                                $get_claim = Claim::find($claim->id);
                                $result =  ($claim->actual_balance / $claim->amount_claim);
                                //    $hypo = ($claim->hypothetical_balance / ($result == 0) ? 0 : $result);
                                $hypo = ($claim->hypothetical_balance != 0 && $result != 0) ? $claim->hypothetical_balance / $result : 0;

                                $claimactual_balance = $claim->actual_balance - $claim->amount_claim;
                                $claim_hype_balance = $claim->hypothetical_balance - $hypo;

                                $get_claim->update([
                                    'actual_balance' => (is_numeric($claimactual_balance) && $claimactual_balance >  0) ? $claimactual_balance : 0,
                                    'hypothetical_balance' => (is_numeric($claim_hype_balance) && $claim_hype_balance >  0) ? $claim_hype_balance : 0,
                                    'user_id' => auth()->user()->id

                                ]);


                                UserClaim::create([
                                    'user_id' => auth()->user()->id,
                                    'claim_id' => $claim->id,
                                    'amount' => $claim->amount_claim,
                                    'company_id' => $companyID,
                                    'status' => 1
                                ]);
                                $this->hypothetical_balance = ($get_claim) ? $get_claim->hypothetical_balance : 0;

                                $this->promo = Promo::where('company_id', $companyID)->where('status', 1)->first();
                                //    $this->promo->id = ($this->promo != null) ? $this->promo->id : 1;
                                if ($this->promo != null) {
                                    $this->promoid = $this->promo->id;
                                }
                                // Add Claim to User Gift Card
                                $claim_promo_type = PromoType::where('type', 'claim')->where('promo_id', $this->promo->id)->first();
                                if (!$claim_promo_type) {
                                    $promo_type = PromoType::create([
                                        'promo_id' => $this->promoid,
                                        'type' => 'claim',
                                        'title' => 'Claim',
                                        'description' => 'Description'
                                    ]);
                                    $this->promo_type = ($promo_type) ? $promo_type : '';
                                } else {
                                    $this->promo_type = $claim_promo_type;
                                }
                                $this->success = true;

                                $user_total_claims = UserClaim::where('user_id', auth()->user()->id)
                                    ->where('company_id', $companyID)
                                    ->latest()->first()->amount;

                                $check_promo =   UserPromo::where('promo_type_id', $this->promo_type->id)
                                    ->where('user_id', auth()->user()->id)
                                    ->where('type', 'claim')
                                    ->where('promo_id', $this->promoid)->first();
                                if ($check_promo) {


                                    $check_promo->update([
                                        'amount' => $check_promo->amount + $user_total_claims * 100,
                                        'type' => 'claim',
                                        'total' =>  $check_promo->total + $user_total_claims * 100,
                                        'total_claim' => ($check_promo->total_claim + 1),
                                        'company_id' => $companyID,
                                    ]);
                                } else {
                                    $userPromo = UserPromo::create([
                                        'promo_id' => $this->promoid,
                                        'promo_type_id' => $this->promo_type->id,
                                        'user_id' => auth()->user()->id,
                                        'type' => 'claim',
                                        'amount' => $user_total_claims * 100,
                                        'taxes' => 0,
                                        'total_claim' => 1,
                                        'order_code' => "",
                                        'total' => $user_total_claims * 100,
                                        'status' => UserPromo::STATUS_COMPLETED,
                                        'action' => UserPromo::APPROVED,
                                        'restaurant_type' => '',
                                        'company_id' => $companyID
                                    ]);
                                }
                            }
                        } else {
                            $get_claim = Claim::find($claim->id);
                            $result =  ($claim->actual_balance / $claim->amount_claim);
                            //    $hypo = ($claim->hypothetical_balance / ($result == 0) ? 0 : $result);
                            $hypo = ($claim->hypothetical_balance != 0 && $result != 0) ? $claim->hypothetical_balance / $result : 0;

                            $claimactual_balance = $claim->actual_balance - $claim->amount_claim;
                            $claim_hype_balance = $claim->hypothetical_balance - $hypo;

                            $get_claim->update([
                                'actual_balance' => (is_numeric($claimactual_balance) && $claimactual_balance >  0) ? $claimactual_balance : 0,
                                'hypothetical_balance' => (is_numeric($claim_hype_balance) && $claim_hype_balance >  0) ? $claim_hype_balance : 0,
                                'user_id' => auth()->user()->id

                            ]);


                            UserClaim::create([
                                'user_id' => auth()->user()->id,
                                'claim_id' => $claim->id,
                                'company_id' => $companyID,
                                'amount' => $claim->amount_claim,
                                'status' => 1
                            ]);
                            $this->hypothetical_balance = ($get_claim) ? $get_claim->hypothetical_balance : 0;

                            $this->promo = Promo::where('company_id', $companyID)->where('status', 1)->first();
                            //    $this->promo->id = ($this->promo != null) ? $this->promo->id : 1;
                            if ($this->promo != null) {
                                $this->promoid = $this->promo->id;
                            }
                            // Add Claim to User Gift Card
                            $claim_promo_type = PromoType::where('type', 'claim')->where('promo_id', $this->promo->id)->first();
                            if (!$claim_promo_type) {
                                $promo_type = PromoType::create([
                                    'promo_id' => $this->promoid,
                                    'type' => 'claim',
                                    'title' => 'Claim',
                                    'description' => 'Description'
                                ]);
                                $this->promo_type = ($promo_type) ? $promo_type : '';
                            } else {
                                $this->promo_type = $claim_promo_type;
                            }
                            $this->success = true;


                            $user_total_claims = UserClaim::where('user_id', auth()->user()->id)
                                ->where('company_id', $companyID)
                                ->sum('amount');

                            $check_promo =   UserPromo::where('promo_type_id', $this->promo_type->id)
                                ->where('user_id', auth()->user()->id)
                                ->where('type', 'claim')
                                ->where('promo_id', $this->promoid)->first();
                            if ($check_promo) {


                                $check_promo->update([
                                    'amount' => $check_promo->amount + $user_total_claims * 100,
                                    'type' => 'claim',
                                    'total' =>  $check_promo->total + $user_total_claims * 100,
                                    'total_claim' => ($check_promo->total_claim + 1),
                                    'company_id' => $companyID
                                ]);
                            } else {
                                $userPromo = UserPromo::create([
                                    'promo_id' => $this->promoid,
                                    'promo_type_id' => $this->promo_type->id,
                                    'user_id' => auth()->user()->id,
                                    'type' => 'claim',
                                    'amount' => $user_total_claims * 100,
                                    'taxes' => 0,
                                    'total_claim' => 1,
                                    'order_code' => "",
                                    'total' => $user_total_claims * 100,
                                    'status' => UserPromo::STATUS_COMPLETED,
                                    'action' => UserPromo::APPROVED,
                                    'restaurant_type' => '',
                                    'company_id' => $companyID
                                ]);
                            }
                        }
                    }

                    // $user_total_claims = UserClaim::where('user_id', auth()->user()->id)
                    // ->sum('amount');



                } else {
                    $models_claim = UserClaim::where('user_id', auth()->user()->id)
                        ->where('company_id', $companyID)
                        ->where('claim_id', $claim->id)->latest()->first();





                    if ($models_claim) {
                        Carbon::setTestNow(Carbon::now('UTC'));

                        $datetime1 = Carbon::now()->format('Y-m-d');


                        $datetime2 = Carbon::parse($models_claim->created_at)->format('Y-m-d');

                        $datetime1 =  Carbon::parse($datetime1);
                        $datetime2 =  Carbon::parse($datetime2);
                        $days = $datetime1->diffInDays($datetime2);



                        if ($days == 0) {
                            // $this->claim_limit = 'Daily limit exceeded';
                        } else {
                            $this->promo = Promo::where('company_id', $companyID)->where('status', 1)->first();
                            $claim_promo_type_check = PromoType::where('type', 'claim')->where('promo_id', $this->promo->id)->first();

                            if (!$this->promo) {
                                // $this->claim_limit = "Company Promo Not found";
                                // $this->emit('claim-event-warning','Company Promo Not found');
                                $this->promo_found = false;
                            } else {
                                $promo_balance =   UserPromo::where('promo_type_id', $claim_promo_type_check->id)
                                    ->where('user_id', auth()->user()->id)
                                    ->where('type', 'claim')
                                    ->where('promo_id', $this->promo->id)->first();

                                if ($promo_balance) {
                                    $amountAvailable = $promo_balance->getAmountAvailableAttribute();
                                    // $amountAvailable = $amountAvailable / 100;
                                    // dd($amountAvailable);
                                    if (($amountAvailable + ($claim->amount_claim  * 100)) > $this->first_user * 100) {
                                        // dd($promo_balance);
                                        // $this->claim_limit = 'Claim Balance limit exceeded';

                                    } else {
                                        $get_claim = Claim::find($claim->id);
                                        $result =  ($claim->actual_balance / $claim->amount_claim);
                                        //    $hypo = ($claim->hypothetical_balance / ($result == 0) ? 0 : $result);
                                        $hypo = ($claim->hypothetical_balance != 0 && $result != 0) ? $claim->hypothetical_balance / $result : 0;

                                        $claimactual_balance = $claim->actual_balance - $claim->amount_claim;
                                        $claim_hype_balance = $claim->hypothetical_balance - $hypo;

                                        $get_claim->update([
                                            'actual_balance' => (is_numeric($claimactual_balance) && $claimactual_balance >  0) ? $claimactual_balance : 0,
                                            'hypothetical_balance' => (is_numeric($claim_hype_balance) && $claim_hype_balance >  0) ? $claim_hype_balance : 0,
                                            'user_id' => auth()->user()->id

                                        ]);


                                        UserClaim::create([
                                            'user_id' => auth()->user()->id,
                                            'claim_id' => $claim->id,
                                            'company_id' => $companyID,
                                            'amount' => $claim->amount_claim,
                                            'status' => 1
                                        ]);
                                        $this->hypothetical_balance = ($get_claim) ? $get_claim->hypothetical_balance : 0;

                                        $this->promo = Promo::where('company_id', $companyID)->where('status', 1)->first();
                                        //    $this->promo->id = ($this->promo != null) ? $this->promo->id : 1;
                                        if ($this->promo != null) {
                                            $this->promoid = $this->promo->id;
                                        }
                                        // Add Claim to User Gift Card
                                        $claim_promo_type = PromoType::where('type', 'claim')->where('promo_id', $this->promo->id)->first();
                                        if (!$claim_promo_type) {
                                            $promo_type = PromoType::create([
                                                'promo_id' => $this->promoid,
                                                'type' => 'claim',
                                                'title' => 'Claim',
                                                'description' => 'Description'
                                            ]);
                                            $this->promo_type = ($promo_type) ? $promo_type : '';
                                        } else {
                                            $this->promo_type = $claim_promo_type;
                                        }
                                        $this->success = true;


                                        $user_total_claims = UserClaim::where('user_id', auth()->user()->id)
                                            ->where('company_id', $companyID)
                                            ->latest()->first()->amount;

                                        $check_promo =   UserPromo::where('promo_type_id', $this->promo_type->id)
                                            ->where('user_id', auth()->user()->id)
                                            ->where('type', 'claim')
                                            ->where('promo_id', $this->promoid)->first();
                                        if ($check_promo) {


                                            $check_promo->update([
                                                'amount' => $check_promo->amount + $user_total_claims * 100,
                                                'type' => 'claim',
                                                'total' =>  $check_promo->total + $user_total_claims * 100,
                                                'total_claim' => ($check_promo->total_claim + 1),
                                                'company_id' => $companyID
                                            ]);
                                        } else {
                                            $userPromo = UserPromo::create([
                                                'promo_id' => $this->promoid,
                                                'promo_type_id' => $this->promo_type->id,
                                                'user_id' => auth()->user()->id,
                                                'type' => 'claim',
                                                'amount' => $user_total_claims * 100,
                                                'taxes' => 0,
                                                'total_claim' => 1,
                                                'order_code' => "",
                                                'total' => $user_total_claims * 100,
                                                'status' => UserPromo::STATUS_COMPLETED,
                                                'action' => UserPromo::APPROVED,
                                                'restaurant_type' => '',
                                                'company_id' => $companyID
                                            ]);
                                        }
                                    }
                                } else {
                                    $get_claim = Claim::find($claim->id);
                                    $result =  ($claim->actual_balance / $claim->amount_claim);
                                    //    $hypo = ($claim->hypothetical_balance / ($result == 0) ? 0 : $result);
                                    $hypo = ($claim->hypothetical_balance != 0 && $result != 0) ? $claim->hypothetical_balance / $result : 0;

                                    $claimactual_balance = $claim->actual_balance - $claim->amount_claim;
                                    $claim_hype_balance = $claim->hypothetical_balance - $hypo;

                                    $get_claim->update([
                                        'actual_balance' => (is_numeric($claimactual_balance) && $claimactual_balance >  0) ? $claimactual_balance : 0,
                                        'hypothetical_balance' => (is_numeric($claim_hype_balance) && $claim_hype_balance >  0) ? $claim_hype_balance : 0,
                                        'user_id' => auth()->user()->id

                                    ]);


                                    UserClaim::create([
                                        'user_id' => auth()->user()->id,
                                        'claim_id' => $claim->id,
                                        'company_id' => $companyID,
                                        'amount' => $claim->amount_claim,
                                        'status' => 1
                                    ]);
                                    $this->hypothetical_balance = ($get_claim) ? $get_claim->hypothetical_balance : 0;

                                    $this->promo = Promo::where('company_id', $companyID)->where('status', 1)->first();
                                    //    $this->promo->id = ($this->promo != null) ? $this->promo->id : 1;
                                    if ($this->promo != null) {
                                        $this->promoid = $this->promo->id;
                                    }
                                    // Add Claim to User Gift Card
                                    $claim_promo_type = PromoType::where('type', 'claim')->where('promo_id', $this->promo->id)->first();
                                    if (!$claim_promo_type) {
                                        $promo_type = PromoType::create([
                                            'promo_id' => $this->promoid,
                                            'type' => 'claim',
                                            'title' => 'Claim',
                                            'description' => 'Description'
                                        ]);
                                        $this->promo_type = ($promo_type) ? $promo_type : '';
                                    } else {
                                        $this->promo_type = $claim_promo_type;
                                    }
                                    $this->success = true;


                                    $user_total_claims = UserClaim::where('user_id', auth()->user()->id)
                                        ->where('company_id', $companyID)
                                        ->latest()->first()->amount;

                                    $check_promo =   UserPromo::where('promo_type_id', $this->promo_type->id)
                                        ->where('user_id', auth()->user()->id)
                                        ->where('type', 'claim')
                                        ->where('promo_id', $this->promoid)->first();
                                    if ($check_promo) {


                                        $check_promo->update([
                                            'amount' => $check_promo->amount + $user_total_claims * 100,
                                            'type' => 'claim',
                                            'total' =>  $check_promo->total + $user_total_claims * 100,
                                            'total_claim' => ($check_promo->total_claim + 1),
                                            'company_id' => $companyID
                                        ]);
                                    } else {
                                        $userPromo = UserPromo::create([
                                            'promo_id' => $this->promoid,
                                            'promo_type_id' => $this->promo_type->id,
                                            'user_id' => auth()->user()->id,
                                            'type' => 'claim',
                                            'amount' => $user_total_claims * 100,
                                            'taxes' => 0,
                                            'total_claim' => 1,
                                            'order_code' => "",
                                            'total' => $user_total_claims * 100,
                                            'status' => UserPromo::STATUS_COMPLETED,
                                            'action' => UserPromo::APPROVED,
                                            'restaurant_type' => '',
                                            'company_id' => $companyID
                                        ]);
                                    }
                                }
                            }
                        }
                    } else {

                        $this->promo = Promo::where('company_id', $companyID)->where('status', 1)->first();
                        $claim_promo_type_check = PromoType::where('type', 'claim')->where('promo_id', $this->promo->id)->first();

                        if (!$this->promo) {
                            // $this->claim_limit = "Company Promo Not found";
                            $this->promo_found = false;
                        } else {
                            $promo_balance =   UserPromo::where('promo_type_id', $claim_promo_type_check->id)
                                ->where('user_id', auth()->user()->id)
                                ->where('type', 'claim')
                                ->where('promo_id', $this->promo->id)->first();
                            // dd("ss".$promo_balance);
                            if ($promo_balance) {
                                $amountAvailable = $promo_balance->getAmountAvailableAttribute();
                                // $amountAvailable = $amountAvailable / 100;
                                if (($amountAvailable + ($claim->amount_claim  * 100)) > $this->first_user * 100) {

                                    // $this->claim_limit = 'Claim Balance limit exceeded';

                                } else {
                                    $get_claim = Claim::find($claim->id);
                                    $result =  ($claim->actual_balance / $claim->amount_claim);
                                    //    $hypo = ($claim->hypothetical_balance / ($result == 0) ? 0 : $result);
                                    $hypo = ($claim->hypothetical_balance != 0 && $result != 0) ? $claim->hypothetical_balance / $result : 0;

                                    $claimactual_balance = $claim->actual_balance - $claim->amount_claim;
                                    $claim_hype_balance = $claim->hypothetical_balance - $hypo;

                                    $get_claim->update([
                                        'actual_balance' => (is_numeric($claimactual_balance) && $claimactual_balance >  0) ? $claimactual_balance : 0,
                                        'hypothetical_balance' => (is_numeric($claim_hype_balance) && $claim_hype_balance >  0) ? $claim_hype_balance : 0,
                                        'user_id' => auth()->user()->id

                                    ]);


                                    UserClaim::create([
                                        'user_id' => auth()->user()->id,
                                        'claim_id' => $claim->id,
                                        'company_id' => $companyID,
                                        'amount' => $claim->amount_claim,
                                        'status' => 1
                                    ]);
                                    $this->hypothetical_balance = ($get_claim) ? $get_claim->hypothetical_balance : 0;

                                    $this->promo = Promo::where('company_id', $companyID)->where('status', 1)->first();
                                    //    $this->promo->id = ($this->promo != null) ? $this->promo->id : 1;
                                    if ($this->promo != null) {
                                        $this->promoid = $this->promo->id;
                                    }
                                    // Add Claim to User Gift Card
                                    $claim_promo_type = PromoType::where('type', 'claim')->where('promo_id', $this->promo->id)->first();
                                    if (!$claim_promo_type) {
                                        $promo_type = PromoType::create([
                                            'promo_id' => $this->promoid,
                                            'type' => 'claim',
                                            'title' => 'Claim',
                                            'description' => 'Description'
                                        ]);
                                        $this->promo_type = ($promo_type) ? $promo_type : '';
                                    } else {
                                        $this->promo_type = $claim_promo_type;
                                    }
                                    $this->success = true;


                                    $user_total_claims = UserClaim::where('user_id', auth()->user()->id)
                                        ->where('company_id', $companyID)
                                        ->latest()->first()->amount;

                                    $check_promo =   UserPromo::where('promo_type_id', $this->promo_type->id)
                                        ->where('user_id', auth()->user()->id)
                                        ->where('type', 'claim')
                                        ->where('promo_id', $this->promoid)->first();
                                    if ($check_promo) {


                                        $check_promo->update([
                                            'amount' => $check_promo->amount + $user_total_claims * 100,
                                            'type' => 'claim',
                                            'total' =>  $check_promo->total + $user_total_claims * 100,
                                            'total_claim' => ($check_promo->total_claim + 1),
                                            'company_id' => $companyID
                                        ]);
                                    } else {
                                        $userPromo = UserPromo::create([
                                            'promo_id' => $this->promoid,
                                            'promo_type_id' => $this->promo_type->id,
                                            'user_id' => auth()->user()->id,
                                            'type' => 'claim',
                                            'amount' => $user_total_claims * 100,
                                            'taxes' => 0,
                                            'total_claim' => 1,
                                            'order_code' => "",
                                            'total' => $user_total_claims * 100,
                                            'status' => UserPromo::STATUS_COMPLETED,
                                            'action' => UserPromo::APPROVED,
                                            'restaurant_type' => '',
                                            'company_id' => $companyID
                                        ]);
                                    }
                                }
                            } else {
                                $get_claim = Claim::find($claim->id);
                                $result =  ($claim->actual_balance / $claim->amount_claim);
                                //    $hypo = ($claim->hypothetical_balance / ($result == 0) ? 0 : $result);
                                $hypo = ($claim->hypothetical_balance != 0 && $result != 0) ? $claim->hypothetical_balance / $result : 0;

                                $claimactual_balance = $claim->actual_balance - $claim->amount_claim;
                                $claim_hype_balance = $claim->hypothetical_balance - $hypo;

                                $get_claim->update([
                                    'actual_balance' => (is_numeric($claimactual_balance) && $claimactual_balance >  0) ? $claimactual_balance : 0,
                                    'hypothetical_balance' => (is_numeric($claim_hype_balance) && $claim_hype_balance >  0) ? $claim_hype_balance : 0,
                                    'user_id' => auth()->user()->id

                                ]);


                                UserClaim::create([
                                    'user_id' => auth()->user()->id,
                                    'claim_id' => $claim->id,
                                    'company_id' => $companyID,
                                    'amount' => $claim->amount_claim,
                                    'status' => 1
                                ]);
                                $this->hypothetical_balance = ($get_claim) ? $get_claim->hypothetical_balance : 0;

                                $this->promo = Promo::where('company_id', $companyID)->where('status', 1)->first();
                                //    $this->promo->id = ($this->promo != null) ? $this->promo->id : 1;
                                if ($this->promo != null) {
                                    $this->promoid = $this->promo->id;
                                }
                                // Add Claim to User Gift Card
                                $claim_promo_type = PromoType::where('type', 'claim')->where('promo_id', $this->promo->id)->first();
                                if (!$claim_promo_type) {
                                    $promo_type = PromoType::create([
                                        'promo_id' => $this->promoid,
                                        'type' => 'claim',
                                        'title' => 'Claim',
                                        'description' => 'Description'
                                    ]);
                                    $this->promo_type = ($promo_type) ? $promo_type : '';
                                } else {
                                    $this->promo_type = $claim_promo_type;
                                }
                                $this->success = true;


                                $user_total_claims = UserClaim::where('user_id', auth()->user()->id)
                                    ->where('company_id', $companyID)
                                    ->latest()->first()->amount;

                                $check_promo =   UserPromo::where('promo_type_id', $this->promo_type->id)
                                    ->where('user_id', auth()->user()->id)
                                    ->where('type', 'claim')
                                    ->where('promo_id', $this->promoid)->first();
                                if ($check_promo) {


                                    $check_promo->update([
                                        'amount' => $check_promo->amount + $user_total_claims * 100,
                                        'type' => 'claim',
                                        'total' =>  $check_promo->total + $user_total_claims * 100,
                                        'total_claim' => ($check_promo->total_claim + 1),
                                        'company_id' => $companyID
                                    ]);
                                } else {
                                    $userPromo = UserPromo::create([
                                        'promo_id' => $this->promoid,
                                        'promo_type_id' => $this->promo_type->id,
                                        'user_id' => auth()->user()->id,
                                        'type' => 'claim',
                                        'amount' => $user_total_claims * 100,
                                        'taxes' => 0,
                                        'total_claim' => 1,
                                        'order_code' => "",
                                        'total' => $user_total_claims * 100,
                                        'status' => UserPromo::STATUS_COMPLETED,
                                        'action' => UserPromo::APPROVED,
                                        'restaurant_type' => '',
                                        'company_id' => $companyID
                                    ]);
                                }
                            }
                        }
                    }
                }
            } else {
            }
        } else {
            // $this->emit('claim-event-warning', '.');
        }
    }
}
