<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class ProductGroupRule implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $groups = json_decode($value);

        if(request('option_type') == "group"){

            if(count($groups) <= 0) $fail("Please Fillup the group details");

            foreach ($groups as $group) {
                if(!$group->group || !$group->upto) {
                    $fail("Please Fillup the group details");
                }
            }
        }
    }
}
