<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->integer('status')->nullable()->comment('new, table_assigned, paid, canceled');
            $table->integer('type')->nullable()->comment('dine-in, take-out, reservation, delivery');
            $table->foreignId('company_id')->constrained()->onDelete("cascade");
            $table->foreignId('user_id')->constrained()->onDelete("cascade");
            $table->integer('area_id')->nullable();
            $table->integer('table_id')->nullable();
            $table->integer('employee_id')->nullable();
            // $table->decimal('number', 10, 0)->nullable();
            // $table->longText("products")->nullable();
            $table->decimal('subtotal', 10, 2)->nullable();
            $table->decimal('tax', 10, 2)->nullable();
            $table->decimal('tips', 10, 2)->nullable();
            $table->decimal('discount', 10, 2)->nullable();
            $table->decimal('used_egift', 10, 2)->nullable();
            $table->decimal('total', 10, 2)->nullable();

            // $table->unsignedBigInteger('transaction_id')->nullable();
            // $table->foreign('transaction_id')->references('id')->on('transactions')->onUpdate('cascade')->onDelete('cascade');

            // $table->unsignedBigInteger('tip_id')->nullable();
            // $table->foreign('tip_id')->references('id')->on('tips')->onUpdate('cascade')->onDelete('cascade');

            // $table->double("refund_amount",8,2)->nullable();
            // $table->tinyInteger('is_refund_requested')->default(0)->comment("0:No,1:Yes");
            // $table->enum('refund_type',['partial','full'])->default(NULL)->nullable()->comment("partial,full");
            // $table->double('refund_requested_amount')->default(NULL)->nullable();
            // $table->double('refunded_amount')->default(NULL)->nullable();
            // $table->double('refund_reason')->default(NULL)->nullable();
            
            // $table->enum('table_area_type',['pickup','table'])->default('table');
            // $table->tinyInteger('is_pickup_confirmed')->nullable()->comment("1:Confirmed else No (If  table type is pickup)");

            // $table->timestamp('canceled_at')->nullable();
            $table->timestamps();
            $table->softDeletes();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
};
