<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            // $table->integer('user_order_id')->nullable();
            $table->foreignId('order_id')->nullable();
            $table->foreignId('employee_id')->nullable();
            $table->foreignId('company_id')->nullable();
            $table->string('type')->nullable(); //card, card-walkin, card-app, cash
            $table->integer('user_id')->nullable();
            $table->string('charge_id')->nullable();
            $table->string('payment_intent_id')->nullable();

            $table->integer('amount')->nullable();
            $table->integer('change')->nullable();
            $table->text('user_promo_id')->nullable();
            $table->integer('is_payout')->default(0);
            
            $table->string("refund_reason")->nullable();
            $table->string("refund_id")->nullable();
            $table->integer("refund_promo_id")->nullable();

            $table->timestamps();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transactions');
    }
};
